/*
 * Decompiled with CFR 0.152.
 */
package de.muehlbauer.mw.egov.ifc;

import de.muehlbauer.mw.egov.impl.EgovCardService;
import java.util.Enumeration;
import java.util.Vector;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardType;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import org.bouncycastle.util.encoders.Hex;

public class EgovCardServiceFactory
extends CardServiceFactory {
    byte[] EGOV_AID = Hex.decode((String)"F0496173456363526F6F74");
    private static final Vector<Class<EgovCardService>> service_classes = new Vector();
    public static final int CARDTYPE_EGOV = 8;

    static {
        service_classes.addElement(EgovCardService.class);
    }

    protected CardType getCardType(CardID cid, CardServiceScheduler scheduler) throws CardTerminalException {
        CommandAPDU capdu = new CommandAPDU(50);
        capdu.append((byte)0);
        capdu.append((byte)-92);
        capdu.append((byte)4);
        capdu.append((byte)12);
        capdu.append((byte)this.EGOV_AID.length);
        capdu.append(this.EGOV_AID);
        ResponseAPDU rsp = scheduler.getSlotChannel().sendAPDU(capdu);
        if (rsp.sw() == 36864) {
            service_classes.addElement(EgovCardService.class);
            return new CardType(8);
        }
        return CardType.UNSUPPORTED;
    }

    protected Enumeration<Class<EgovCardService>> getClasses(CardType type) {
        return service_classes.elements();
    }
}

