/*
 * Decompiled with CFR 0.152.
 */
package de.muehlbauer.mw.egov.impl;

import de.cardcontact.opencard.service.CardServiceUnexpectedStatusWordException;
import de.cardcontact.opencard.service.isocard.IsoCardSelector;
import de.muehlbauer.mw.egov.ifc.DataGroup;
import de.muehlbauer.mw.egov.ifc.EgovCardServiceInterface;
import de.muehlbauer.mw.egov.ifc.EgovException;
import de.muehlbauer.mw.protocol.container.PACEInfo;
import de.muehlbauer.mw.protocol.util.PaceUtil;
import de.muehlbauer.mw.util.ISOCommandAPDU;
import de.muehlbauer.mw.util.MWUtil;
import de.muehlbauer.mw.util.OIDTable;
import de.muehlbauer.mw.util.SelectedApplet;
import de.muehlbauer.mw.util.securechannel.MBSecureChannel;
import de.muehlbauer.mw.util.securechannel.SecureChannelProtocol;
import de.muehlbauer.mw.util.tlv.TLVUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import opencard.core.service.CHVDialog;
import opencard.core.service.CardChannel;
import opencard.core.service.CardService;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import opencard.core.util.Tracer;
import opencard.opt.iso.fs.CardFilePath;
import opencard.opt.service.CardServiceObjectNotAvailableException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.Arrays;

public class EgovCardService
extends CardService
implements EgovCardServiceInterface {
    private static final int MAX_WRITE_BUF_LEN = 200;
    private byte[] pin = new byte[]{1, 2, 3, 4};
    private boolean useExtendedLengthAPDUs = false;
    private static Tracer ctracer = new Tracer(EgovCardService.class);

    public EgovCardService() {
        BouncyCastleProvider bcprovider = new BouncyCastleProvider();
        Security.addProvider((Provider)bcprovider);
        this.establishAppletConnection();
    }

    @Override
    public void useExtendedLengthAPDUs(boolean b) {
        this.useExtendedLengthAPDUs = b;
    }

    @Override
    public byte[] readDataGroup(byte[] fid) throws EgovException {
        this.allocateCardChannel();
        CardChannel cc = this.establishAppletConnection();
        byte[] dataGroup = this.readDataGroup(cc, fid);
        this.releaseCardChannel();
        return dataGroup;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] readDataGroup(CardChannel cc, byte[] fid) throws EgovException {
        try {
            ISOCommandAPDU capdu = new ISOCommandAPDU(0, -92, 2, 0, fid);
            ResponseAPDU rsp = MWUtil.sendCommandAPDU(capdu, cc);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int offset = 0;
            rsp = this.readSelectedDG(cc, offset);
            if (this.useExtendedLengthAPDUs && rsp.sw() == 26368) {
                throw new EgovException("Wrong Length. Extended Length probably not supported.");
            }
            if (rsp.sw() != 36864 && rsp.sw() != 25218 && rsp.sw() != 27392 && rsp.data() == null) {
                ctracer.error("[readDataGroup]", "Could not read data from card");
                throw new EgovException("Could not read data from card: " + Integer.toHexString(rsp.sw()));
            }
            while (rsp.sw() == 36864) {
                if (rsp.data().length < 223) {
                    return bos.toByteArray();
                }
                rsp = this.readSelectedDG(cc, offset);
                if (rsp.data() == null) {
                    if (rsp.sw() == 27392) return bos.toByteArray();
                    if (rsp.sw() == 25218) return bos.toByteArray();
                    if (rsp.sw() == 36864) {
                        return bos.toByteArray();
                    }
                }
                bos.write(rsp.data());
                offset += rsp.data().length;
            }
            return bos.toByteArray();
        }
        catch (IOException e) {
            try {
                this.releaseCardChannel();
            }
            catch (InvalidCardChannelException capdu) {
                // empty catch block
            }
            String msg = e.getMessage();
            if (!this.useExtendedLengthAPDUs) throw new EgovException(msg);
            msg = String.valueOf(msg) + "\nTry without extended APDUs";
            throw new EgovException(msg);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void writeDataGroup(byte[] contents, byte[] fid) throws EgovException {
        try {
            try {
                this.allocateCardChannel();
                CardChannel cc = this.establishAppletConnection();
                ISOCommandAPDU capdu = new ISOCommandAPDU(0, -92, 2, 0, fid);
                ResponseAPDU rsp = MWUtil.sendCommandAPDU(capdu, cc);
                if (rsp.sw() != 36864) {
                    throw new EgovException("Could not select file");
                }
                int offset = 0;
                int standardBlockSize = 223;
                int blockSize = contents.length > standardBlockSize ? standardBlockSize : contents.length;
                boolean writtenData = false;
                while (rsp.sw() == 36864) {
                    if (offset >= contents.length) {
                        return;
                    }
                    byte[] chunk = java.util.Arrays.copyOfRange(contents, offset, offset + blockSize);
                    capdu = new ISOCommandAPDU(0, -42, (byte)(offset >> 8), (byte)(offset & 0xFF), chunk);
                    rsp = MWUtil.sendCommandAPDU(capdu, cc);
                    if (rsp.sw() != 36864) {
                        throw new EgovException("Could not update file");
                    }
                    blockSize = contents.length - (offset += blockSize) > standardBlockSize ? standardBlockSize : contents.length - offset;
                }
                return;
            }
            catch (EgovException e) {
                throw e;
            }
            catch (IOException e) {
                throw new EgovException(e);
            }
        }
        finally {
            this.releaseCardChannel();
        }
    }

    private CardChannel establishAppletConnection() {
        CardChannel cc = null;
        try {
            CardFilePath path = new CardFilePath("#4D4F4E54454E4547524F");
            cc = this.getCardChannel();
            IsoCardSelector cardSelector = null;
            if (cc != null) {
                cardSelector = (IsoCardSelector)cc.getState();
            }
            if (cardSelector == null) {
                cardSelector = new IsoCardSelector(path);
            }
            cc = this.getCardChannel();
            cardSelector.selectFile(cc, null, path);
            return cc;
        }
        catch (InvalidCardChannelException e) {
            e.printStackTrace();
        }
        catch (CardServiceObjectNotAvailableException e) {
            e.printStackTrace();
        }
        catch (CardServiceUnexpectedStatusWordException e) {
            e.printStackTrace();
        }
        catch (CardTerminalException e) {
            e.printStackTrace();
        }
        return cc;
    }

    private boolean selectEgov(CardChannel cc) throws EgovException, CardTerminalException {
        if (SelectedApplet.equals("egov")) {
            return true;
        }
        String defaultAID = "4D4F4E54454E4547524F";
        String cDataString = "";
        byte cla = 0;
        byte ins = -92;
        byte p1 = 4;
        byte p2 = 12;
        cDataString = defaultAID;
        byte[] cData = HexString.parseHexString((String)cDataString);
        ISOCommandAPDU cmd = new ISOCommandAPDU(cla, ins, p1, p2, cData);
        ResponseAPDU rsp = MWUtil.sendCommandAPDU(cmd, cc);
        if (rsp.sw() != 36864) {
            throw new EgovException(rsp.sw());
        }
        SelectedApplet.SetName("egov");
        return true;
    }

    @Override
    public boolean verify(byte[] pin, byte id) throws EgovException {
        try {
            this.allocateCardChannel();
            CardChannel cc = this.establishAppletConnection();
            boolean bl = this.verify(cc, pin, id);
            return bl;
        }
        catch (EgovException e) {
            e.printStackTrace();
        }
        finally {
            this.releaseCardChannel();
        }
        return false;
    }

    public boolean verify(CardChannel cc, byte[] pinBytes, byte id) throws EgovException {
        ISOCommandAPDU capdu = new ISOCommandAPDU(0, 32, 0, id, pinBytes);
        try {
            ResponseAPDU rsp = MWUtil.sendCommandAPDU(capdu, cc);
            if (rsp.sw() != 36864) {
                throw new EgovException(rsp.sw());
            }
            return true;
        }
        catch (InvalidCardChannelException | CardTerminalException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean selectApplet() throws EgovException {
        try {
            this.allocateCardChannel();
            CardChannel cc = this.establishAppletConnection();
            boolean bl = this.selectEgov(cc);
            return bl;
        }
        catch (CardTerminalException e) {
            e.printStackTrace();
        }
        finally {
            this.releaseCardChannel();
        }
        return false;
    }

    @Override
    public void release() throws EgovException {
        try {
            MBSecureChannel.getInstance().reset();
        }
        catch (InvalidCardChannelException ex) {
            throw new EgovException("Reset SecureChannel failed!");
        }
    }

    @Override
    public PACEInfo authenticate(String input, String keyIdentifier) throws IOException {
        byte[] inputByte = input.getBytes();
        byte keyId = keyIdentifier.toLowerCase().equals("can") ? (byte)2 : 1;
        return this.authenticatePacePCSC(inputByte, keyId, null);
    }

    /*
     * Exception decompiling
     */
    private PACEInfo authenticatePacePCSC(byte[] paceKey, byte keyId, String paceOID) throws EgovException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PACEInfo establishPaceWithoutTerminal(CardChannel cc, byte[] paceKey, byte keyId, String paceOID) throws EgovException, IOException, NoSuchAlgorithmException, NoSuchProviderException, RuntimeException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException {
        byte[] cardAccess = null;
        byte ecCurveID = 0;
        String numberOID = null;
        byte[] oidByte = null;
        try {
            cardAccess = this.readBinary(cc, DataGroup.CardAccess);
            String tlvCardAccess = TLVUtil.getTLV(cardAccess);
            numberOID = paceOID == null ? OIDTable.GetAlgorithm(tlvCardAccess) : paceOID;
            oidByte = OIDTable.OID2Byte(numberOID);
            ecCurveID = TLVUtil.findCurveIdAfterPaceOID(tlvCardAccess, numberOID);
        }
        catch (EgovException e) {
            if (e.getMessage().contains("Could not select file (0x6a82)")) {
                throw new EgovException("SAC not supported");
            }
            throw new EgovException(e);
        }
        catch (IOException e) {
            if (e.getMessage().contains("incorrect TLV Structure")) {
                throw new EgovException("Couldn\ufffdt parse TLV Structure of EF.CardAccess");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EgovException("Unknown Exception");
        }
        if (paceKey != null) {
            paceKey = PaceUtil.KDF(paceKey, (byte)3, oidByte[oidByte.length - 1]);
        } else if (this.getCHVDialog() != null) {
            paceKey = this.getAuthKeys(keyId, oidByte[oidByte.length - 1]);
        } else {
            throw new EgovException("CHV Dialog not set");
        }
        PACEInfo paceInfo = this.paceProtocol(cc, paceKey, numberOID, ecCurveID, keyId);
        SelectedApplet.SetName("");
        return paceInfo;
    }

    private byte[] readBinary(CardChannel cc, DataGroup dg) throws EgovException {
        byte[] data = null;
        try {
            this.selectDG(dg, cc);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int offset = 0;
            ResponseAPDU rsp = this.readSelectedDG(cc, offset);
            if (rsp.sw() != 36864 && rsp.sw() != 25218 && rsp.sw() != 27392 && rsp.data() == null) {
                throw new EgovException("Could not read data from card: " + Integer.toHexString(rsp.sw()));
            }
            int dgLength = MWUtil.getLengthDG(rsp.data());
            while (offset < dgLength) {
                rsp = this.readSelectedDG(cc, offset);
                if (rsp.data() == null && (rsp.sw() == 27392 || rsp.sw() == 25218 || rsp.sw() == 36864)) break;
                if (rsp.data().length > dgLength - offset) {
                    bos.write(rsp.data(), 0, dgLength - offset);
                } else {
                    bos.write(rsp.data());
                }
                offset += rsp.data().length;
            }
            data = bos.toByteArray();
        }
        catch (EgovException e) {
            try {
                this.releaseCardChannel();
            }
            catch (InvalidCardChannelException offset) {
                // empty catch block
            }
            throw e;
        }
        catch (IOException e) {
            try {
                this.releaseCardChannel();
            }
            catch (InvalidCardChannelException offset) {
                // empty catch block
            }
            String msg = e.getMessage();
            if (this.useExtendedLengthAPDUs) {
                msg = String.valueOf(msg) + "\nTry without extended APDUs";
            }
            throw new EgovException(msg);
        }
        return data;
    }

    private void selectDG(DataGroup dg, CardChannel cc) throws CardTerminalException, EgovException {
        CommandAPDU capdu = new CommandAPDU(50);
        capdu.append((byte)0);
        capdu.append((byte)-92);
        capdu.append((byte)2);
        capdu.append((byte)12);
        capdu.append((byte)2);
        capdu.append((byte)(dg.getFid() >> 8));
        capdu.append((byte)(dg.getFid() & 0xFF));
        ResponseAPDU rsp = MWUtil.sendCommandAPDU(capdu, cc);
        if (rsp.sw() != 36864) {
            if (rsp.sw() == 27010) {
                throw new EgovException("Security Conditions not satisfied (0x" + Integer.toHexString(rsp.sw()) + ")");
            }
            if (rsp.sw() == 27016) {
                throw new EgovException("Secure Channel not available (0x" + Integer.toHexString(rsp.sw()) + ")");
            }
            throw new EgovException("Could not select file (0x" + Integer.toHexString(rsp.sw()) + ")");
        }
    }

    private ResponseAPDU readSelectedDG(CardChannel cc, Integer offset) throws CardTerminalException {
        CommandAPDU capdu = new CommandAPDU(50);
        capdu.setLength(0);
        capdu.append((byte)0);
        capdu.append((byte)-80);
        capdu.append((byte)(offset >> 8));
        capdu.append((byte)(offset & 0xFF));
        capdu.append((byte)0);
        if (this.useExtendedLengthAPDUs) {
            capdu.append((byte)0);
            capdu.append((byte)0);
        }
        return MWUtil.sendCommandAPDU(capdu, cc);
    }

    private byte[] getAuthKeys(byte keyIdentifier, byte keyLength) throws NoSuchAlgorithmException, NoSuchProviderException, IOException, RuntimeException {
        CHVDialog chvDialog = this.getCHVDialog();
        byte[] hashedPin = null;
        String input = chvDialog.getCHV((int)keyIdentifier);
        if (!MWUtil.isNumeric(input) || input.equals("")) {
            return null;
        }
        hashedPin = keyIdentifier == 8 ? MWUtil.fetoOS(new BigInteger(input, 10), 16) : PaceUtil.KDF(input.getBytes(), (byte)3, keyLength);
        return hashedPin;
    }

    private PACEInfo paceProtocol(CardChannel cc, byte[] paceKey, String oid, byte ecCurveID, byte keyIdentifier) throws InvalidKeyException, IOException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidAlgorithmParameterException, NoSuchProviderException {
        Cipher cipher = null;
        PACEInfo paceInfo = new PACEInfo();
        paceInfo.setOID(oid);
        try {
            cipher = Cipher.getInstance(paceInfo.getCipherAlgorithm(), (Provider)new BouncyCastleProvider());
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            e.printStackTrace();
        }
        if (ecCurveID == 0) {
            throw new EgovException("ECCurve Parameter missing");
        }
        SecretKeySpec secretPaceKey = new SecretKeySpec(paceKey, paceInfo.getCipherAlgorithm());
        this.paceManageSeAPDU(cc, paceInfo.getOIDBytes(), keyIdentifier, ecCurveID);
        try {
            if (paceInfo.getReadableOID().contains("3DES")) {
                IvParameterSpec ivspec = new IvParameterSpec(new byte[8]);
                cipher.init(2, (Key)secretPaceKey, ivspec);
            } else {
                cipher.init(2, secretPaceKey);
            }
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            throw new EgovException("Java Policy");
        }
        byte[] encr_Nonce = this.paceEncryptedNonceAPDU(cc);
        byte[] decr_Nonce = cipher.doFinal(encr_Nonce);
        ECNamedCurveParameterSpec usedCurveSpec = ECNamedCurveTable.getParameterSpec((String)OIDTable.GetECCurve(ecCurveID));
        BigInteger ecP = usedCurveSpec.getCurve().getField().getCharacteristic();
        BigInteger ecA = usedCurveSpec.getCurve().getA().toBigInteger();
        BigInteger ecB = usedCurveSpec.getCurve().getB().toBigInteger();
        BigInteger ecX = usedCurveSpec.getG().getXCoord().toBigInteger();
        BigInteger ecY = usedCurveSpec.getG().getYCoord().toBigInteger();
        BigInteger ecOrder = usedCurveSpec.getN();
        int ecH = usedCurveSpec.getH().intValue();
        EllipticCurve ecCurve = EC5Util.convertCurve((ECCurve)usedCurveSpec.getCurve(), (byte[])usedCurveSpec.getSeed());
        ECPoint ecGenerator = new ECPoint(ecX, ecY);
        ECParameterSpec ecParamSpec = new ECParameterSpec(ecCurve, ecGenerator, ecOrder, ecH);
        int pubKeySizeByte = (ecParamSpec.getOrder().bitLength() + 7) / 8;
        KeyPairGenerator kpgen = null;
        kpgen = KeyPairGenerator.getInstance(paceInfo.getDhAlgorithm());
        kpgen.initialize(ecParamSpec);
        KeyPair map_pcd = kpgen.generateKeyPair();
        ECPublicKey pk_map_pcd = (ECPublicKey)map_pcd.getPublic();
        ECPrivateKey sk_map_pcd = (ECPrivateKey)map_pcd.getPrivate();
        paceInfo.setFirstPKID(pk_map_pcd);
        byte[] pk_map_picc_byte = this.paceMapNonceAPDU(cc, pk_map_pcd);
        ECPublicKey pk_map_picc = MWUtil.ConvertToECPubKey(pk_map_picc_byte, ecParamSpec);
        paceInfo.setFirstPKICC(pk_map_picc);
        if (pk_map_pcd.equals(pk_map_picc)) {
            return this.paceProtocol(cc, paceKey, oid, ecCurveID, keyIdentifier);
        }
        BigInteger[] pk_map_piccPoint = new BigInteger[]{pk_map_picc.getW().getAffineX(), pk_map_picc.getW().getAffineY()};
        BigInteger[] hECDH = PaceUtil.DoubleAndAddECPoint(sk_map_pcd.getS(), pk_map_piccPoint, ecA, ecP);
        ECPoint mappedGenerator = PaceUtil.GetMappedGenerator(decr_Nonce, hECDH, ecGenerator, ecA, ecB, ecP);
        ECParameterSpec mappedECParameterSpec = new ECParameterSpec(ecCurve, mappedGenerator, ecOrder, ecH);
        kpgen.initialize(mappedECParameterSpec);
        KeyPair dh_pcd = kpgen.generateKeyPair();
        ECPublicKey pk_dh_pcd = (ECPublicKey)dh_pcd.getPublic();
        ECPrivateKey sk_dh_pcd = (ECPrivateKey)dh_pcd.getPrivate();
        paceInfo.setSecondPKID(pk_dh_pcd);
        byte[] pk_dh_picc_byte = this.paceKeyAgreementAPDU(cc, pk_dh_pcd);
        if (pk_dh_picc_byte == null) {
            return this.paceProtocol(cc, paceKey, oid, ecCurveID, keyIdentifier);
        }
        ECPublicKey pk_dh_picc = MWUtil.ConvertToECPubKey(pk_dh_picc_byte, mappedECParameterSpec);
        paceInfo.setSecondPKICC(pk_dh_picc);
        if (pk_dh_pcd.equals(pk_dh_picc)) {
            return this.paceProtocol(cc, paceKey, oid, ecCurveID, keyIdentifier);
        }
        BigInteger[] pk_dh_piccPoint = new BigInteger[]{pk_dh_picc.getW().getAffineX(), pk_dh_picc.getW().getAffineY()};
        byte[] kECDHX = MWUtil.fetoOS(PaceUtil.DoubleAndAddECPoint(sk_dh_pcd.getS(), pk_dh_piccPoint, ecA, ecP)[0], pubKeySizeByte);
        SecretKeySpec kenc = new SecretKeySpec(PaceUtil.KDF(kECDHX, (byte)1, paceInfo.getOIDBytes()[paceInfo.getOIDBytes().length - 1]), paceInfo.getMacAlgorithm());
        SecretKeySpec kmac = new SecretKeySpec(PaceUtil.KDF(kECDHX, (byte)2, paceInfo.getOIDBytes()[paceInfo.getOIDBytes().length - 1]), paceInfo.getMacAlgorithm());
        paceInfo.setkEnc(kenc);
        paceInfo.setkMac(kmac);
        byte[] terminalMac = PaceUtil.GetMacFromAuthenticationToken(pk_dh_picc, (SecretKey)kmac, paceInfo.getOIDBytes(), paceInfo.getMacAlgorithm());
        byte[] appletResponseStep4 = this.paceMutualAuthenticateAPDU(cc, terminalMac, keyIdentifier);
        if (paceInfo.getReadableOID().contains("CAM")) {
            keyIdentifier = (byte)(keyIdentifier | 0x20);
            paceInfo.setPaceCAM(true);
        }
        MBSecureChannel.openSecureChannel(kenc, kmac, SecureChannelProtocol.getFromId(keyIdentifier), null);
        this.verifyAuthenticationToken(paceInfo, appletResponseStep4, cc);
        paceInfo.setCompressedSecondPKICC(MWUtil.GetCompressedKey(pk_dh_picc));
        paceInfo.setCompressedSecondPKTerm(MWUtil.GetCompressedKey(pk_dh_pcd));
        return paceInfo;
    }

    private void verifyAuthenticationToken(PACEInfo paceInfo, byte[] appletAnswer, CardChannel cc) throws InvalidKeyException, NoSuchAlgorithmException, IOException {
        byte[] terminalMac = PaceUtil.GetMacFromAuthenticationToken((ECPublicKey)paceInfo.getSecondPKID(), paceInfo.getkMac(), paceInfo.getOIDBytes(), paceInfo.getMacAlgorithm());
        byte[] appletMac = new byte[8];
        System.arraycopy(appletAnswer, 4, appletMac, 0, appletMac.length);
        if (!Arrays.areEqual((byte[])terminalMac, (byte[])appletMac)) {
            throw new EgovException("Card MAC verification failed");
        }
        if (paceInfo.isPaceCAM()) {
            byte[] cardSecurity = this.readBinary(cc, DataGroup.CardSecurity);
            Throwable throwable = null;
            Object var8_9 = null;
            try (ASN1InputStream asn1in = new ASN1InputStream(cardSecurity);){
                DLSequence sequenceSOD = (DLSequence)asn1in.readObject();
                DERTaggedObject taggedContent = (DERTaggedObject)sequenceSOD.getObjectAt(1);
                DERSequence content = (DERSequence)taggedContent.getObject();
                SignedData signedData = SignedData.getInstance((Object)content);
                byte[] eContent = signedData.getEncapContentInfo().getContent().toASN1Primitive().getEncoded();
                ASN1OctetString octedString = ASN1OctetString.getInstance((Object)eContent);
                ASN1Set asn1Set = ASN1Set.getInstance((Object)octedString.getOctets());
                ASN1Encodable asn1Encode = asn1Set.parser().readObject();
                while (asn1Encode != null) {
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void paceManageSeAPDU(CardChannel cc, byte[] oidBytes, byte keyIdentifier, byte curveIdentifier) throws IOException {
        byte[] cData = null;
        byte cla = 0;
        byte ins = 34;
        byte p1 = -63;
        byte p2 = -92;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(HexString.parseHexString((String)"80"));
        bos.write(oidBytes.length);
        bos.write(oidBytes);
        bos.write(HexString.parseHexString((String)"8301"));
        bos.write(keyIdentifier);
        bos.write(HexString.parseHexString((String)"8401"));
        bos.write(curveIdentifier);
        cData = bos.toByteArray();
        byte lc = (byte)cData.length;
        CommandAPDU cmd = new CommandAPDU(5 + lc);
        cmd.append(cla);
        cmd.append(ins);
        cmd.append(p1);
        cmd.append(p2);
        cmd.append(lc);
        cmd.append(cData);
        ResponseAPDU rsp = MWUtil.sendCommandAPDU(cmd, cc);
        if (keyIdentifier != 3 && keyIdentifier != 4 && rsp.sw() != 36864) {
            throw new EgovException("Manage Security Environment failed");
        }
        if ((keyIdentifier == 3 || keyIdentifier == 4) && (rsp.sw() & 0xFFF0) != 25536 && rsp.sw() != 36864) {
            throw new EgovException("Manage Security Environment failed");
        }
    }

    private byte[] paceEncryptedNonceAPDU(CardChannel cc) throws CardTerminalException, EgovException {
        byte cla = 16;
        byte ins = -122;
        byte p1 = 0;
        byte p2 = 0;
        byte[] cData = HexString.parseHexString((String)"7C00");
        byte lc = (byte)cData.length;
        byte le = 0;
        CommandAPDU cmd = new CommandAPDU(6 + lc);
        cmd.append(cla);
        cmd.append(ins);
        cmd.append(p1);
        cmd.append(p2);
        cmd.append(lc);
        cmd.append(cData);
        cmd.append(le);
        ResponseAPDU rsp = MWUtil.sendCommandAPDU(cmd, cc);
        if (rsp.sw() != 36864) {
            throw new EgovException("PACE Step 1 (Encrypted Nonce) failed");
        }
        byte[] encrNonce = new byte[16];
        if (rsp.data()[0] == 124 && rsp.data()[2] == -128) {
            System.arraycopy(rsp.data(), 4, encrNonce, 0, rsp.data().length - 4);
        }
        return encrNonce;
    }

    private byte[] paceMapNonceAPDU(CardChannel cc, ECPublicKey pk_map_pcd) throws EgovException, IOException {
        int pubKeySizeByte = pk_map_pcd.getParams().getOrder().bitLength() / 8;
        byte[] cData = null;
        byte cla = 16;
        byte ins = -122;
        byte p1 = 0;
        byte p2 = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(HexString.parseHexString((String)"7C"));
        bos.write(3 + pubKeySizeByte * 2);
        bos.write(HexString.parseHexString((String)"81"));
        bos.write(1 + pubKeySizeByte * 2);
        bos.write(HexString.parseHexString((String)"04"));
        bos.write(MWUtil.fetoOS(pk_map_pcd.getW().getAffineX(), pubKeySizeByte));
        bos.write(MWUtil.fetoOS(pk_map_pcd.getW().getAffineY(), pubKeySizeByte));
        cData = bos.toByteArray();
        byte lc = (byte)cData.length;
        CommandAPDU cmd = new CommandAPDU(6 + lc);
        cmd.append(cla);
        cmd.append(ins);
        cmd.append(p1);
        cmd.append(p2);
        cmd.append(lc);
        cmd.append(cData);
        cmd.append((byte)0);
        ResponseAPDU rsp = MWUtil.sendCommandAPDU(cmd, cc);
        if (rsp.sw() != 36864) {
            System.out.println("RSP SW: " + Integer.toHexString(rsp.sw()));
            throw new EgovException("PACE Step 2 (Mapping) failed");
        }
        byte[] pk_icc = new byte[rsp.data().length - 5];
        if (rsp.data()[0] == 124 && rsp.data()[2] == -126 && rsp.data()[4] == 4) {
            System.arraycopy(rsp.data(), 5, pk_icc, 0, rsp.data().length - 5);
        }
        return pk_icc;
    }

    private byte[] paceKeyAgreementAPDU(CardChannel cc, ECPublicKey pk_dh_pcd) throws IOException {
        int pubKeySizeByte = pk_dh_pcd.getParams().getOrder().bitLength() / 8;
        byte[] cData = null;
        byte cla = 16;
        byte ins = -122;
        byte p1 = 0;
        byte p2 = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(HexString.parseHexString((String)"7C"));
        bos.write(3 + pubKeySizeByte * 2);
        bos.write(HexString.parseHexString((String)"83"));
        bos.write(1 + pubKeySizeByte * 2);
        bos.write(HexString.parseHexString((String)"04"));
        bos.write(MWUtil.fetoOS(pk_dh_pcd.getW().getAffineX(), pubKeySizeByte));
        bos.write(MWUtil.fetoOS(pk_dh_pcd.getW().getAffineY(), pubKeySizeByte));
        cData = bos.toByteArray();
        byte lc = (byte)cData.length;
        CommandAPDU cmd = new CommandAPDU(6 + lc);
        cmd.append(cla);
        cmd.append(ins);
        cmd.append(p1);
        cmd.append(p2);
        cmd.append(lc);
        cmd.append(cData);
        cmd.append((byte)0);
        ResponseAPDU rsp = MWUtil.sendCommandAPDU(cmd, cc);
        if (rsp.sw() != 36864) {
            return null;
        }
        byte[] pubKey = new byte[rsp.data().length - 5];
        if (rsp.data()[0] == 124 && rsp.data()[2] == -124 && rsp.data()[4] == 4) {
            System.arraycopy(rsp.data(), 5, pubKey, 0, rsp.data().length - 5);
        }
        return pubKey;
    }

    private byte[] paceMutualAuthenticateAPDU(CardChannel cc, byte[] terminalMac, byte keyIdentifier) throws IOException {
        byte cla = 0;
        byte ins = -122;
        byte p1 = 0;
        byte p2 = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(HexString.parseHexString((String)"7C"));
        bos.write(2 + terminalMac.length);
        bos.write(HexString.parseHexString((String)"85"));
        bos.write(terminalMac.length);
        bos.write(terminalMac);
        byte[] cData = bos.toByteArray();
        byte lc = (byte)cData.length;
        CommandAPDU cmd = new CommandAPDU(6 + lc);
        cmd.append(cla);
        cmd.append(ins);
        cmd.append(p1);
        cmd.append(p2);
        cmd.append(lc);
        cmd.append(cData);
        cmd.append((byte)0);
        ResponseAPDU rsp = MWUtil.sendCommandAPDU(cmd, cc);
        if (rsp.sw() != 36864) {
            if (keyIdentifier == 3 || keyIdentifier == 4) {
                throw new EgovException(25551);
            }
            throw new EgovException(3);
        }
        return rsp.data();
    }
}

