/*
 * Decompiled with CFR 0.152.
 */
package de.muehlbauer.mw.protocol.container;

import java.math.BigInteger;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.HashMap;

public class ChipAuthenticationDomainParameter {
    private boolean isECC;
    private String caOID;
    private BigInteger ecA;
    private BigInteger ecB;
    private BigInteger ecP;
    private ECPoint ecBase;
    private BigInteger ecOrder;
    private int ecCoFactor;
    private byte[] publicKey;
    private ECParameterSpec ecParamSpec;
    private int keyID = -1;

    public ChipAuthenticationDomainParameter(String pOID, BigInteger pA, BigInteger pB, BigInteger pP, byte[] pBase, BigInteger pOrder, int pCofactor, byte[] pPublicKey, int pKeyID) {
        this.caOID = pOID;
        this.ecP = pP;
        this.ecA = pA;
        this.ecB = pB;
        this.ecOrder = pOrder;
        this.ecCoFactor = pCofactor;
        this.publicKey = pPublicKey;
        this.keyID = pKeyID;
        byte[] ecXByte = new byte[pBase.length / 2];
        byte[] ecYByte = new byte[pBase.length / 2];
        System.arraycopy(pBase, 1, ecXByte, 0, pBase.length / 2);
        System.arraycopy(pBase, 1 + pBase.length / 2, ecYByte, 0, pBase.length / 2);
        ECFieldFp ecField = new ECFieldFp(this.ecP);
        this.ecBase = new ECPoint(new BigInteger(1, ecXByte), new BigInteger(1, ecYByte));
        EllipticCurve ecCurve = new EllipticCurve(ecField, this.ecA, this.ecB);
        this.ecParamSpec = new ECParameterSpec(ecCurve, this.ecBase, this.ecOrder, this.ecCoFactor);
        this.isECC = true;
    }

    public boolean isECC() {
        return this.isECC;
    }

    public void setECC(boolean isECC) {
        this.isECC = isECC;
    }

    public String getCaOID() {
        return this.caOID;
    }

    public void setCaOID(String caOID) {
        this.caOID = caOID;
    }

    public BigInteger getEcA() {
        return this.ecA;
    }

    public void setEcA(BigInteger ecA) {
        this.ecA = ecA;
    }

    public BigInteger getEcB() {
        return this.ecB;
    }

    public void setEcB(BigInteger ecB) {
        this.ecB = ecB;
    }

    public BigInteger getEcP() {
        return this.ecP;
    }

    public void setEcP(BigInteger ecP) {
        this.ecP = ecP;
    }

    public ECPoint getEcBase() {
        return this.ecBase;
    }

    public void setEcBase(ECPoint ecBase) {
        this.ecBase = ecBase;
    }

    public BigInteger getEcOrder() {
        return this.ecOrder;
    }

    public void setEcOrder(BigInteger ecOrder) {
        this.ecOrder = ecOrder;
    }

    public int getEcCoFactor() {
        return this.ecCoFactor;
    }

    public void setEcCoFactor(int ecCoFactor) {
        this.ecCoFactor = ecCoFactor;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(byte[] publicKey) {
        this.publicKey = publicKey;
    }

    public ECParameterSpec getEcParamSpec() {
        return this.ecParamSpec;
    }

    public void setEcParamSpec(ECParameterSpec ecParamSpec) {
        this.ecParamSpec = ecParamSpec;
    }

    public String getKeyAlgorithm() {
        if (this.caOID.contains("AES")) {
            return "AES";
        }
        return "DESede";
    }

    public static int getIndexOfBestProtocol(String[] caOID) {
        HashMap<String, Integer> preferedProtocolList = new HashMap<String, Integer>();
        preferedProtocolList.put("0.4.0.127.0.7.2.2.3.2.4", 1);
        preferedProtocolList.put("0.4.0.127.0.7.2.2.3.2.3", 2);
        preferedProtocolList.put("0.4.0.127.0.7.2.2.3.2.2", 3);
        preferedProtocolList.put("0.4.0.127.0.7.2.2.3.2.1", 7);
        int currentValue = 99;
        int currentIndex = -1;
        int i = 0;
        while (i < caOID.length) {
            Integer tmpInt = (Integer)preferedProtocolList.get(caOID[i]);
            if (tmpInt != null && tmpInt < currentValue) {
                currentIndex = i;
            }
            ++i;
        }
        return currentIndex;
    }

    public int getKeyID() {
        return this.keyID;
    }

    public void setKeyID(int keyID) {
        this.keyID = keyID;
    }
}

