/*
 * Decompiled with CFR 0.152.
 */
package de.muehlbauer.mw.protocol.container;

import de.muehlbauer.mw.util.OIDTable;
import java.security.PublicKey;
import javax.crypto.SecretKey;

public class PACEInfo {
    private PublicKey firstPKICC = null;
    private PublicKey secondPKICC = null;
    private PublicKey firstPKID = null;
    private PublicKey secondPKID = null;
    private String cipherAlgorithm = null;
    private String macAlgorithm = null;
    private String dhAlgorithm = null;
    private String OID = null;
    private String readableOID = null;
    private byte[] OIDBytes = null;
    private byte[] compressedSecondPKICC = null;
    private byte[] compressedSecondPKTerm = null;
    private SecretKey kEnc = null;
    private SecretKey kMac = null;
    private boolean isPaceCAM = false;
    private Boolean isPaceCAMAuthenticated = null;

    public PublicKey getFirstPKICC() {
        return this.firstPKICC;
    }

    public void setFirstPKICC(PublicKey firstPKICC) {
        this.firstPKICC = firstPKICC;
    }

    public PublicKey getSecondPKICC() {
        return this.secondPKICC;
    }

    public void setSecondPKICC(PublicKey secondPKICC) {
        this.secondPKICC = secondPKICC;
    }

    public PublicKey getFirstPKID() {
        return this.firstPKID;
    }

    public void setFirstPKID(PublicKey firstPKID) {
        this.firstPKID = firstPKID;
    }

    public PublicKey getSecondPKID() {
        return this.secondPKID;
    }

    public void setSecondPKID(PublicKey secondPKID) {
        this.secondPKID = secondPKID;
    }

    public String getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public void setCipherAlgorithm(String cipherAlgorithm) {
        this.cipherAlgorithm = cipherAlgorithm;
    }

    public String getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public void setMacAlgorithm(String macAlgorithm) {
        this.macAlgorithm = macAlgorithm;
    }

    public String getDhAlgorithm() {
        return this.dhAlgorithm;
    }

    public void setDhAlgorithm(String dhAlgorithm) {
        this.dhAlgorithm = dhAlgorithm;
    }

    public String getOID() {
        return this.OID;
    }

    public void setOID(String oID) {
        this.OID = oID;
        this.readableOID = OIDTable.getOIDTableMap().get(this.OID);
        this.OIDBytes = OIDTable.OID2Byte(this.OID);
        this.cipherAlgorithm = this.readableOID.contains("3DES") ? "DESede/CBC/NoPadding" : "AES/ECB/NoPadding";
        this.macAlgorithm = this.readableOID.contains("3DES") ? "DESede" : "AES";
        this.dhAlgorithm = this.readableOID.contains("ECDH") ? "ECDH" : "DH";
    }

    public byte[] getOIDBytes() {
        return this.OIDBytes;
    }

    public void setOIDBytes(byte[] oIDBytes) {
        this.OIDBytes = oIDBytes;
    }

    public String getReadableOID() {
        return this.readableOID;
    }

    public void setReadableOID(String readableOID) {
        this.readableOID = readableOID;
    }

    public SecretKey getkEnc() {
        return this.kEnc;
    }

    public void setkEnc(SecretKey kEnc) {
        this.kEnc = kEnc;
    }

    public SecretKey getkMac() {
        return this.kMac;
    }

    public void setkMac(SecretKey kMac) {
        this.kMac = kMac;
    }

    public byte[] getCompressedSecondPKICC() {
        return this.compressedSecondPKICC;
    }

    public void setCompressedSecondPKICC(byte[] compressedSecondPKICC) {
        this.compressedSecondPKICC = compressedSecondPKICC;
    }

    public byte[] getCompressedSecondPKTerm() {
        return this.compressedSecondPKTerm;
    }

    public void setCompressedSecondPKTerm(byte[] compressedSecondPKTerm) {
        this.compressedSecondPKTerm = compressedSecondPKTerm;
    }

    public boolean isPaceCAM() {
        return this.isPaceCAM;
    }

    public void setPaceCAM(boolean isPaceCAM) {
        this.isPaceCAM = isPaceCAM;
    }

    public Boolean isPaceCAMAuthenticated() {
        return this.isPaceCAMAuthenticated;
    }

    public void setPaceCAMAuthenticated(boolean isPaceCAMAuthenticated) {
        this.isPaceCAMAuthenticated = isPaceCAMAuthenticated;
    }
}

