/*
 * Decompiled with CFR 0.152.
 */
package de.muehlbauer.mw.protocol.util;

import de.muehlbauer.mw.protocol.container.ChipAuthenticationDomainParameter;
import de.muehlbauer.mw.util.MWUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class CAUtil {
    protected CAUtil() {
    }

    public static KeyPair generateKeyPair(ChipAuthenticationDomainParameter caParam) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        String dhAlgorithm = caParam.getCaOID().contains("ECDH") ? "ECDH" : "DH";
        KeyPairGenerator kpgen = null;
        kpgen = KeyPairGenerator.getInstance(dhAlgorithm);
        kpgen.initialize(caParam.getEcParamSpec());
        KeyPair ephemeralKeyPair = kpgen.generateKeyPair();
        return ephemeralKeyPair;
    }

    public static byte[] KDF(byte[] k, byte c, String oid) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            if (oid.endsWith("CBC") || oid.endsWith("128")) {
                MessageDigest sha = MessageDigest.getInstance("SHA-1");
                bos.write(k);
                bos.write(MWUtil.Get32Bit_BigEndian(c));
                byte[] hashKey = sha.digest(bos.toByteArray());
                byte[] resKey = new byte[16];
                System.arraycopy(hashKey, 0, resKey, 0, 16);
                return resKey;
            }
            if (oid.endsWith("192")) {
                MessageDigest sha = MessageDigest.getInstance("SHA-256");
                byte[] resKey = new byte[24];
                bos.write(k);
                bos.write(MWUtil.Get32Bit_BigEndian(c));
                byte[] hashKey = sha.digest(bos.toByteArray());
                System.arraycopy(hashKey, 0, resKey, 0, 24);
                return resKey;
            }
            if (oid.endsWith("256")) {
                MessageDigest sha = MessageDigest.getInstance("SHA-256");
                bos.write(k);
                bos.write(MWUtil.Get32Bit_BigEndian(c));
                byte[] hashinput = bos.toByteArray();
                byte[] hashKey = sha.digest(hashinput);
                return hashKey;
            }
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }
}

