/*
 * Decompiled with CFR 0.152.
 */
package de.muehlbauer.mw.protocol.util;

import de.muehlbauer.mw.egov.ifc.EgovException;
import de.muehlbauer.mw.util.MWUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.util.HashMap;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import opencard.core.util.HexString;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class PaceUtil {
    protected PaceUtil() {
    }

    public static byte[] GetMacFromAuthenticationToken(ECPublicKey pubkey, SecretKey kmac, byte[] oidBytes, String macAlgorithm) throws EgovException, IOException, NoSuchAlgorithmException, InvalidKeyException {
        int pubKeySize = pubkey.getParams().getOrder().bitLength() / 8;
        Mac signer = null;
        signer = macAlgorithm.equals("AES") ? Mac.getInstance("AESCMAC") : Mac.getInstance("ISO9797ALG3MAC", (Provider)new BouncyCastleProvider());
        signer.init(kmac);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(HexString.parseHexString((String)"7F49"));
        bos.write(2 + oidBytes.length + 1 + 1 + 1 + pubKeySize * 2);
        bos.write(HexString.parseHexString((String)"06"));
        bos.write(oidBytes.length);
        bos.write(oidBytes);
        bos.write(HexString.parseHexString((String)"86"));
        bos.write(1 + pubKeySize * 2);
        bos.write(HexString.parseHexString((String)"04"));
        bos.write(MWUtil.fetoOS(pubkey.getW().getAffineX(), pubKeySize));
        bos.write(MWUtil.fetoOS(pubkey.getW().getAffineY(), pubKeySize));
        byte[] dataToSign = bos.toByteArray();
        if (macAlgorithm.equals("DESede")) {
            dataToSign = PaceUtil.padForDes(dataToSign);
        }
        byte[] terminalMacFull = signer.doFinal(dataToSign);
        byte[] terminalMac8Byte = new byte[8];
        System.arraycopy(terminalMacFull, 0, terminalMac8Byte, 0, 8);
        return terminalMac8Byte;
    }

    public static byte[] GetMacFromAuthenticationToken(byte[] pubkey, SecretKey kmac, byte[] oidBytes, String macAlgorithm) throws EgovException, IOException, NoSuchAlgorithmException, InvalidKeyException {
        Mac signer = null;
        signer = macAlgorithm.equals("AES") ? Mac.getInstance("AESCMAC") : Mac.getInstance("ISO9797ALG3MAC", (Provider)new BouncyCastleProvider());
        signer.init(kmac);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(HexString.parseHexString((String)"7F49"));
        bos.write(2 + oidBytes.length + 1 + 1 + pubkey.length);
        bos.write(HexString.parseHexString((String)"06"));
        bos.write(oidBytes.length);
        bos.write(oidBytes);
        bos.write(HexString.parseHexString((String)"86"));
        bos.write(pubkey.length);
        bos.write(pubkey);
        byte[] dataToSign = bos.toByteArray();
        if (macAlgorithm.equals("DESede")) {
            dataToSign = PaceUtil.padForDes(dataToSign);
        }
        byte[] terminalMacFull = signer.doFinal(dataToSign);
        byte[] terminalMac8Byte = new byte[8];
        System.arraycopy(terminalMacFull, 0, terminalMac8Byte, 0, 8);
        return terminalMac8Byte;
    }

    private static byte[] padForDes(byte[] inputByte) throws IOException {
        int missingByte = inputByte.length % 8;
        if (missingByte == 0) {
            missingByte = 8;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(inputByte);
        bos.write(128);
        int i = 1;
        while (i < missingByte) {
            bos.write(0);
            ++i;
        }
        return bos.toByteArray();
    }

    public static BigInteger[] DoubleECPoint(BigInteger[] P, BigInteger pA, BigInteger prime) {
        BigInteger[] r = new BigInteger[2];
        BigInteger two = new BigInteger("2");
        BigInteger three = new BigInteger("3");
        BigInteger lambda = P[0].modPow(two, prime).multiply(three).mod(prime).add(pA).mod(prime).multiply(P[1].add(P[1]).modInverse(prime)).mod(prime);
        r[0] = lambda.modPow(two, prime).subtract(two.multiply(P[0]).mod(prime)).mod(prime);
        r[1] = lambda.multiply(P[0].subtract(r[0])).subtract(P[1]).mod(prime);
        return r;
    }

    public static BigInteger[] AddECPoint(BigInteger[] P, BigInteger[] Q, BigInteger pA, BigInteger prime) {
        if (P.equals(Q)) {
            return PaceUtil.DoubleECPoint(P, pA, prime);
        }
        BigInteger[] r = new BigInteger[2];
        BigInteger two = new BigInteger("2");
        BigInteger lambda = Q[1].subtract(P[1]).mod(prime).multiply(Q[0].subtract(P[0]).modInverse(prime)).mod(prime);
        r[0] = lambda.modPow(two, prime).subtract(P[0]).subtract(Q[0]).mod(prime);
        r[1] = lambda.multiply(P[0].subtract(r[0])).subtract(P[1]).mod(prime);
        return r;
    }

    public static BigInteger[] DoubleAndAddECPoint(BigInteger n, BigInteger[] P, BigInteger pA, BigInteger prime) {
        BigInteger[] r = P;
        BigInteger two = new BigInteger("2");
        String bits = "";
        do {
            bits = n.mod(two).equals(BigInteger.ONE) ? "1" + bits : "0" + bits;
        } while ((n = n.divide(two)).compareTo(BigInteger.ONE) > 0);
        int i = 0;
        while (i < bits.length()) {
            r = PaceUtil.DoubleECPoint(r, pA, prime);
            if (bits.charAt(i) == '1') {
                r = PaceUtil.AddECPoint(r, P, pA, prime);
            }
            ++i;
        }
        return r;
    }

    public static ECPoint GetMappedGenerator(byte[] decrNonce, BigInteger[] hECDH, ECPoint oldGenerator, BigInteger pA, BigInteger pB, BigInteger prime) throws EgovException {
        BigInteger n = new BigInteger(1, decrNonce);
        BigInteger[] oldGenInt = new BigInteger[]{oldGenerator.getAffineX(), oldGenerator.getAffineY()};
        BigInteger[] newGenerator = PaceUtil.DoubleAndAddECPoint(n, oldGenInt, pA, prime);
        newGenerator = PaceUtil.AddECPoint(newGenerator, hECDH, pA, prime);
        ECPoint gMap = new ECPoint(newGenerator[0], newGenerator[1]);
        if (!newGenerator[1].pow(2).mod(prime).equals(newGenerator[0].pow(3).add(pA.multiply(newGenerator[0]).mod(prime).add(pB)).mod(prime))) {
            throw new EgovException("The Calculated Point (GMAP) is no element of the curve");
        }
        return gMap;
    }

    public static byte[] KDF(byte[] k, byte c, byte lengthByte) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            if (lengthByte == 1) {
                MessageDigest sha = MessageDigest.getInstance("SHA-1");
                bos.write(k);
                bos.write(MWUtil.Get32Bit_BigEndian(c));
                byte[] hashKey = sha.digest(bos.toByteArray());
                byte[] resKey = new byte[16];
                System.arraycopy(hashKey, 0, resKey, 0, 16);
                return resKey;
            }
            if (lengthByte == 2) {
                MessageDigest sha = MessageDigest.getInstance("SHA-1");
                byte[] resKey = new byte[16];
                bos.write(k);
                bos.write(MWUtil.Get32Bit_BigEndian(c));
                byte[] hashKey = sha.digest(bos.toByteArray());
                System.arraycopy(hashKey, 0, resKey, 0, 16);
                return resKey;
            }
            if (lengthByte == 3) {
                MessageDigest sha = MessageDigest.getInstance("SHA-256");
                byte[] resKey = new byte[24];
                bos.write(k);
                bos.write(MWUtil.Get32Bit_BigEndian(c));
                byte[] hashKey = sha.digest(bos.toByteArray());
                System.arraycopy(hashKey, 0, resKey, 0, 24);
                return resKey;
            }
            if (lengthByte == 4) {
                MessageDigest sha = MessageDigest.getInstance("SHA-256");
                bos.write(k);
                bos.write(MWUtil.Get32Bit_BigEndian(c));
                byte[] hashKey = sha.digest(bos.toByteArray());
                return hashKey;
            }
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static String getBestPACEOID(String[] pOIDs) {
        HashMap<String, Integer> preferedProtocolList = new HashMap<String, Integer>();
        if (pOIDs == null || pOIDs.length == 0) {
            return null;
        }
        preferedProtocolList.put("0.4.0.127.0.7.2.2.4.6.4", 1);
        preferedProtocolList.put("0.4.0.127.0.7.2.2.4.6.3", 2);
        preferedProtocolList.put("0.4.0.127.0.7.2.2.4.6.2", 3);
        preferedProtocolList.put("0.4.0.127.0.7.2.2.4.2.4", 4);
        preferedProtocolList.put("0.4.0.127.0.7.2.2.4.2.3", 5);
        preferedProtocolList.put("0.4.0.127.0.7.2.2.4.2.2", 6);
        preferedProtocolList.put("0.4.0.127.0.7.2.2.4.2.1", 7);
        int currentValue = 99;
        int currentIndex = -1;
        int i = 0;
        while (i < pOIDs.length) {
            Integer tmpInt = (Integer)preferedProtocolList.get(pOIDs[i]);
            if (tmpInt != null && tmpInt < currentValue) {
                currentIndex = i;
            }
            ++i;
        }
        if (currentIndex != -1) {
            return pOIDs[currentIndex];
        }
        return null;
    }
}

