/*
 * Decompiled with CFR 0.152.
 */
package de.muehlbauer.mw.sscd.ifc;

import de.muehlbauer.mw.sscd.impl.SscdCardService;
import java.util.Enumeration;
import java.util.Vector;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardType;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import org.bouncycastle.util.encoders.Hex;

public class SscdCardServiceFactory
extends CardServiceFactory {
    byte[] SSCD_ADF = Hex.decode((String)"E828BD080FD2504543432D654944");
    byte[] DS_DF = Hex.decode((String)"DF01");
    private static final Vector<Class<SscdCardService>> service_classes = new Vector();
    public static final int CARDTYPE_EGOV = 8;

    static {
        service_classes.addElement(SscdCardService.class);
    }

    protected CardType getCardType(CardID cid, CardServiceScheduler scheduler) throws CardTerminalException {
        CommandAPDU capdu = new CommandAPDU(50);
        capdu.append((byte)0);
        capdu.append((byte)-92);
        capdu.append((byte)4);
        capdu.append((byte)12);
        capdu.append((byte)this.SSCD_ADF.length);
        capdu.append(this.SSCD_ADF);
        ResponseAPDU rsp = scheduler.getSlotChannel().sendAPDU(capdu);
        if (rsp.sw() == 36864) {
            service_classes.addElement(SscdCardService.class);
            return new CardType(8);
        }
        return CardType.UNSUPPORTED;
    }

    protected Enumeration<Class<SscdCardService>> getClasses(CardType type) {
        return service_classes.elements();
    }
}

