/*
 * Decompiled with CFR 0.152.
 */
package de.muehlbauer.mw.sscd.impl;

import de.cardcontact.opencard.service.CardServiceUnexpectedStatusWordException;
import de.cardcontact.opencard.service.isocard.IsoCardSelector;
import de.muehlbauer.mw.egov.ifc.EgovException;
import de.muehlbauer.mw.sscd.ifc.ConstantsSscd;
import de.muehlbauer.mw.sscd.ifc.DataGroup;
import de.muehlbauer.mw.sscd.ifc.SscdCardServiceInterface;
import de.muehlbauer.mw.sscd.ifc.SscdException;
import de.muehlbauer.mw.util.ISOCommandAPDU;
import de.muehlbauer.mw.util.MWUtil;
import de.muehlbauer.mw.util.securechannel.MBSecureChannel;
import de.muehlbauer.mw.util.securechannel.SecureChannelProtocol;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import opencard.core.service.CardChannel;
import opencard.core.service.CardService;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.Tracer;
import opencard.opt.iso.fs.CardFilePath;
import opencard.opt.service.CardServiceObjectNotAvailableException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Arrays;

public class SscdCardService
extends CardService
implements SscdCardServiceInterface {
    private static final int MAX_WRITE_BUF_LEN = 200;
    private byte[] pin = new byte[]{1, 2, 3, 4};
    byte[] adminPinValue = new byte[]{57, 57, 57, 57, 57, 57};
    private byte[] cardSerialNumberFromEfSn;
    private boolean useExtendedLengthAPDUs = false;
    private CardChannel theChannel;
    private static Tracer ctracer = new Tracer(SscdCardService.class);

    public SscdCardService() {
        BouncyCastleProvider bcprovider = new BouncyCastleProvider();
        Security.addProvider((Provider)bcprovider);
        this.establishAppletConnection();
    }

    @Override
    public void useExtendedLengthAPDUs(boolean b) {
        this.useExtendedLengthAPDUs = b;
    }

    private byte[] getSn(CardChannel cc) throws SscdException, CardTerminalException {
        byte[] efSnFid = new byte[]{-48, 3};
        byte[] byArray = new byte[2];
        byArray[0] = 63;
        byte[] rootFid = byArray;
        CommandAPDU capdu = new CommandAPDU(50);
        capdu = new ISOCommandAPDU(0, -92, 0, 0, rootFid);
        ResponseAPDU rsp = MWUtil.sendCommandAPDU(capdu, cc);
        if (rsp.sw() != 36864) {
            throw new SscdException("Could not select root file " + rsp.sw());
        }
        capdu = new ISOCommandAPDU(0, -92, 2, 0, efSnFid);
        rsp = MWUtil.sendCommandAPDU(capdu, cc);
        if (rsp.sw() != 36864) {
            throw new SscdException("Could not select file to get SerialNumber " + rsp.sw());
        }
        capdu = new ISOCommandAPDU(0, -80, 0, 2, 8);
        rsp = MWUtil.sendCommandAPDU(capdu, cc);
        if (rsp.sw() != 36864) {
            throw new SscdException("Could not read file to get SerialNumber" + rsp.sw());
        }
        return rsp.getBuffer();
    }

    private CardChannel establishAppletConnection() {
        CardChannel cc = null;
        try {
            CardFilePath path = new CardFilePath("#E828BD080FD2504543432D654944");
            cc = this.getCardChannel();
            IsoCardSelector cardSelector = null;
            if (cc != null) {
                cardSelector = (IsoCardSelector)cc.getState();
            }
            if (cardSelector == null) {
                cardSelector = new IsoCardSelector(path);
            }
            cc = this.getCardChannel();
            cardSelector.selectFile(cc, null, path);
            return cc;
        }
        catch (InvalidCardChannelException e) {
            e.printStackTrace();
        }
        catch (CardServiceObjectNotAvailableException e) {
            e.printStackTrace();
        }
        catch (CardServiceUnexpectedStatusWordException e) {
            e.printStackTrace();
        }
        catch (CardTerminalException e) {
            e.printStackTrace();
        }
        return cc;
    }

    @Override
    public boolean verify(byte[] pin, byte id) throws EgovException {
        try {
            this.allocateCardChannel();
            CardChannel cc = this.establishAppletConnection();
            boolean bl = this.verify(cc, pin, id);
            return bl;
        }
        catch (EgovException e) {
            e.printStackTrace();
        }
        finally {
            this.releaseCardChannel();
        }
        return false;
    }

    public boolean verify(CardChannel cc, byte[] pinBytes, byte id) throws EgovException {
        return false;
    }

    @Override
    public boolean selectApplet() throws SscdException {
        try {
            CardChannel cc;
            this.allocateCardChannel();
            this.theChannel = cc = this.establishAppletConnection();
            boolean bl = this.selectSscd(cc);
            return bl;
        }
        catch (CardTerminalException e) {
            e.printStackTrace();
        }
        finally {
            this.releaseCardChannel();
        }
        return false;
    }

    private boolean selectSscd(CardChannel cc) throws CardTerminalException, SscdException {
        CommandAPDU capdu = new CommandAPDU(50);
        byte[] adf = new byte[]{-24, 40, -67, 8, 15, -46, 80, 69, 67, 67, 45, 101, 73, 68};
        capdu.append((byte)0);
        capdu.append((byte)-92);
        capdu.append((byte)4);
        capdu.append((byte)12);
        capdu.append((byte)14);
        capdu.append(adf);
        ResponseAPDU rsp = MWUtil.sendCommandAPDU(capdu, cc);
        if (rsp.sw() != 36864) {
            if (rsp.sw() == 27010) {
                throw new SscdException("Security Conditions not satisfied (0x" + Integer.toHexString(rsp.sw()) + ")");
            }
            if (rsp.sw() == 27016) {
                throw new SscdException("Secure Channel not available (0x" + Integer.toHexString(rsp.sw()) + ")");
            }
            throw new SscdException("Could not select ADF (0x" + Integer.toHexString(rsp.sw()) + ")");
        }
        return true;
    }

    private boolean selectPki(CardChannel cc) throws CardTerminalException, SscdException {
        CommandAPDU capdu = new CommandAPDU(50);
        byte[] adf = new byte[]{-16, 73, 97, 115, 69, 99, 99, 82, 111, 111, 116};
        capdu.append((byte)0);
        capdu.append((byte)-92);
        capdu.append((byte)4);
        capdu.append((byte)12);
        capdu.append((byte)11);
        capdu.append(adf);
        ResponseAPDU rsp = MWUtil.sendCommandAPDU(capdu, cc);
        if (rsp.sw() != 36864) {
            if (rsp.sw() == 27010) {
                throw new SscdException("Security Conditions not satisfied (0x" + Integer.toHexString(rsp.sw()) + ")");
            }
            if (rsp.sw() == 27016) {
                throw new SscdException("Secure Channel not available (0x" + Integer.toHexString(rsp.sw()) + ")");
            }
            throw new SscdException("Could not select ADF (0x" + Integer.toHexString(rsp.sw()) + ")");
        }
        return true;
    }

    @Override
    public void release() throws SscdException {
        try {
            MBSecureChannel.getInstance().reset();
        }
        catch (InvalidCardChannelException ex) {
            throw new SscdException("Reset SecureChannel failed!");
        }
    }

    private void selectDG(DataGroup dg, CardChannel cc) throws CardTerminalException, EgovException {
        CommandAPDU capdu = new CommandAPDU(50);
        capdu.append((byte)0);
        capdu.append((byte)-92);
        capdu.append((byte)2);
        capdu.append((byte)12);
        capdu.append((byte)2);
        capdu.append((byte)(dg.getFid() >> 8));
        capdu.append((byte)(dg.getFid() & 0xFF));
        ResponseAPDU rsp = MWUtil.sendCommandAPDU(capdu, cc);
        if (rsp.sw() != 36864) {
            if (rsp.sw() == 27010) {
                throw new EgovException("Security Conditions not satisfied (0x" + Integer.toHexString(rsp.sw()) + ")");
            }
            if (rsp.sw() == 27016) {
                throw new EgovException("Secure Channel not available (0x" + Integer.toHexString(rsp.sw()) + ")");
            }
            throw new EgovException("Could not select file (0x" + Integer.toHexString(rsp.sw()) + ")");
        }
    }

    @Override
    public byte[] selectDsDf() throws SscdException, CardTerminalException {
        try {
            this.allocateCardChannel();
            CardChannel cc = this.establishAppletConnection();
            byte[] byArray = this.selectDsDf(cc);
            return byArray;
        }
        finally {
            this.releaseCardChannel();
        }
    }

    private byte[] selectDsDf(CardChannel cc) throws SscdException, CardTerminalException {
        CommandAPDU capdu = new CommandAPDU(50);
        capdu.append((byte)0);
        capdu.append((byte)-92);
        capdu.append((byte)1);
        capdu.append((byte)0);
        capdu.append((byte)2);
        capdu.append(ConstantsSscd.DS_DF[0]);
        capdu.append(ConstantsSscd.DS_DF[1]);
        ResponseAPDU rsp = MWUtil.sendCommandAPDU(capdu, cc);
        if (rsp.sw() != 36864 && rsp.sw() != 25219) {
            if (rsp.sw() == 27010) {
                throw new SscdException("Security Conditions not satisfied (0x" + Integer.toHexString(rsp.sw()) + ")");
            }
            if (rsp.sw() == 27016) {
                throw new SscdException("Secure Channel not available (0x" + Integer.toHexString(rsp.sw()) + ")");
            }
            throw new SscdException("Could not select file (0x" + Integer.toHexString(rsp.sw()) + ")");
        }
        byte[] sw = new byte[]{rsp.sw1(), rsp.sw2()};
        return sw;
    }

    @Override
    public boolean authIasEcc() throws SscdException {
        try {
            this.allocateCardChannel();
            CardChannel cc = this.establishAppletConnection();
            boolean bl = this.authIasEcc(cc);
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseCardChannel();
        }
        return false;
    }

    public boolean authIasEcc(CardChannel cc) throws SscdException {
        try {
            ResponseAPDU rsp;
            ISOCommandAPDU capdu;
            byte[] cardSerialNo;
            byte[] kEncBytes = new byte[]{-93, -35, 69, 25, 28, -72, 41, 89, -21, -77, 68, 9, 31, 105, -28, 38};
            byte[] kMacBytes = new byte[]{84, -73, 34, 120, -52, 32, -44, 53, 98, 86, 20, 116, 119, -11, -104, -96};
            byte[] ivBytes = new byte[8];
            SecretKeySpec kEnc = new SecretKeySpec(kEncBytes, 0, 16, "DESede");
            SecretKeySpec kMac = new SecretKeySpec(kMacBytes, 0, 16, "DESede");
            byte[] rndIfd = new byte[8];
            byte[] snIfd = new byte[8];
            byte[] kIfd = new byte[32];
            new Random().nextBytes(rndIfd);
            new Random().nextBytes(snIfd);
            new Random().nextBytes(kIfd);
            if (this.cardSerialNumberFromEfSn != null && this.cardSerialNumberFromEfSn.length == 8) {
                cardSerialNo = this.cardSerialNumberFromEfSn;
            } else {
                capdu = new ISOCommandAPDU(0, -53, 127, -1, 8);
                rsp = MWUtil.sendCommandAPDU(capdu, cc);
                if (rsp.sw() != 36864) {
                    throw new SscdException(rsp.sw());
                }
                cardSerialNo = java.util.Arrays.copyOfRange(rsp.getBytes(), 0, rsp.getLength() - 2);
            }
            byte[] cdata = new byte[]{-128, 1, 12, -125, 1, -124};
            capdu = new ISOCommandAPDU(0, 34, -63, -92, cdata);
            rsp = MWUtil.sendCommandAPDU(capdu, cc);
            if (rsp.sw() != 36864) {
                throw new SscdException(rsp.sw());
            }
            capdu = new ISOCommandAPDU(0, -124, 0, 0, 8);
            rsp = MWUtil.sendCommandAPDU(capdu, cc);
            if (rsp.sw() != 36864) {
                throw new SscdException(rsp.sw());
            }
            byte[] cardChallenge = java.util.Arrays.copyOfRange(rsp.getBytes(), 0, rsp.getLength() - 2);
            byte[] concatenateArray = Arrays.concatenate((byte[])rndIfd, (byte[])snIfd);
            concatenateArray = Arrays.concatenate((byte[])concatenateArray, (byte[])cardChallenge);
            concatenateArray = Arrays.concatenate((byte[])concatenateArray, (byte[])cardSerialNo, (byte[])kIfd);
            Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding", "BC");
            cipher.init(1, (Key)kEnc, new IvParameterSpec(ivBytes));
            byte[] encBytes = cipher.doFinal(concatenateArray);
            byte[] macBytes = SscdCardService.createMac(encBytes, kMac);
            byte[] cDataAuth = Arrays.concatenate((byte[])encBytes, (byte[])macBytes);
            capdu = new ISOCommandAPDU(0, -126, 0, 0, cDataAuth, 0);
            rsp = MWUtil.sendCommandAPDU(capdu, cc);
            if (rsp.sw() != 36864) {
                throw new SscdException(rsp.sw());
            }
            byte[] eicc = Arrays.copyOfRange((byte[])rsp.getBytes(), (int)0, (int)64);
            byte[] micc = Arrays.copyOfRange((byte[])rsp.getBytes(), (int)64, (int)72);
            byte[] macVBytes = SscdCardService.createMac(eicc, kMac);
            if (!Arrays.areEqual((byte[])macVBytes, (byte[])micc)) {
                throw new SscdException("MAC verification failed");
            }
            byte[] decrypted = SscdCardService.decrypt(eicc, kEnc, ivBytes);
            byte[] rRndICC = Arrays.copyOfRange((byte[])decrypted, (int)0, (int)8);
            byte[] rRndIFD = Arrays.copyOfRange((byte[])decrypted, (int)16, (int)24);
            byte[] kIcc = Arrays.copyOfRange((byte[])decrypted, (int)32, (int)64);
            if (!Arrays.areEqual((byte[])rRndICC, (byte[])cardChallenge)) {
                throw new SscdException("RND.ICC verification failed");
            }
            if (!Arrays.areEqual((byte[])rRndIFD, (byte[])rndIfd)) {
                throw new SscdException("RND.IFD verification failed");
            }
            byte[] kSeed = new byte[]{};
            int round = 0;
            while (round < 32) {
                byte temp1 = kIcc[round];
                byte temp2 = kIfd[round];
                byte temp = (byte)(temp1 ^ temp2);
                kSeed = Arrays.append((byte[])kSeed, (byte)temp);
                ++round;
            }
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] byArray = new byte[4];
            byArray[3] = 1;
            byte[] appendix = byArray;
            byte[] kSeedAppended = Arrays.concatenate((byte[])kSeed, (byte[])appendix);
            byte[] skEnc = Arrays.copyOfRange((byte[])md.digest(kSeedAppended), (int)0, (int)16);
            md.reset();
            byte[] byArray2 = new byte[4];
            byArray2[3] = 2;
            byte[] appendix2 = byArray2;
            byte[] kSeedAppended2 = Arrays.concatenate((byte[])kSeed, (byte[])appendix2);
            byte[] skMac = Arrays.copyOfRange((byte[])md.digest(kSeedAppended2), (int)0, (int)16);
            byte[] temp1 = Arrays.copyOfRange((byte[])cardChallenge, (int)4, (int)8);
            byte[] temp2 = Arrays.copyOfRange((byte[])rndIfd, (int)4, (int)8);
            byte[] ssc = Arrays.concatenate((byte[])temp1, (byte[])temp2);
            System.out.println("Authentication done. SM Keys generated and ready for usage.");
            SecretKeySpec kenc_secretKey = new SecretKeySpec(skEnc, "DESede");
            SecretKeySpec kmac_secretKey = new SecretKeySpec(skMac, "DESede");
            MBSecureChannel.openSecureChannel(kenc_secretKey, kmac_secretKey, SecureChannelProtocol.BAC, ssc);
            return true;
        }
        catch (InvalidCardChannelException | CardTerminalException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException ex) {
            ex.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static byte[] createMac(byte[] input, SecretKey kMac) throws InvalidKeyException, IllegalStateException, IOException, NoSuchAlgorithmException, NoSuchProviderException {
        Mac macV = Mac.getInstance("ISO9797ALG3MAC", "BC");
        macV.init(kMac);
        return macV.doFinal(SscdCardService.padForDes(input));
    }

    private static byte[] decrypt(byte[] input, SecretKey kEnc, byte[] iv) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding", "BC");
        cipher.init(2, (Key)kEnc, new IvParameterSpec(iv));
        return cipher.doFinal(input);
    }

    private static byte[] padForDes(byte[] inputByte) throws IOException {
        int missingByte = inputByte.length % 8;
        if (missingByte == 0) {
            missingByte = 8;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(inputByte);
        bos.write(128);
        int i = 1;
        while (i < missingByte) {
            bos.write(0);
            ++i;
        }
        return bos.toByteArray();
    }

    public boolean verifyRadPin(CardChannel cc, byte[] pin) throws SscdException {
        ISOCommandAPDU capdu = new ISOCommandAPDU(0, 32, 0, -126, pin);
        try {
            ResponseAPDU rsp = MWUtil.sendCommandAPDU(capdu, cc);
            if (rsp.sw() != 36864) {
                throw new SscdException(rsp.sw());
            }
            return true;
        }
        catch (InvalidCardChannelException | CardTerminalException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean verifyAdminPin(byte[] pin) throws SscdException {
        try {
            this.allocateCardChannel();
            CardChannel cc = this.establishAppletConnection();
            boolean bl = this.verifyAdminPin(cc, pin);
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseCardChannel();
        }
        return false;
    }

    public boolean verifyAdminPin(CardChannel cc, byte[] pin) throws SscdException {
        ISOCommandAPDU capdu = new ISOCommandAPDU(0, 32, 0, -125, pin);
        try {
            ResponseAPDU rsp = MWUtil.sendCommandAPDU(capdu, cc);
            if (rsp.sw() != 36864) {
                throw new SscdException(rsp.sw());
            }
            return true;
        }
        catch (InvalidCardChannelException | CardTerminalException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean activateFile() throws SscdException {
        try {
            this.allocateCardChannel();
            CardChannel cc = this.establishAppletConnection();
            boolean bl = this.activateDsDf(cc);
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseCardChannel();
        }
        return false;
    }

    private boolean activateDsDf(CardChannel cc) throws SscdException {
        ISOCommandAPDU capdu = new ISOCommandAPDU(0, 68, 0, 0, 0);
        try {
            ResponseAPDU rsp = MWUtil.sendCommandAPDU(capdu, cc);
            if (rsp.sw() != 36864) {
                throw new SscdException(rsp.sw());
            }
            return true;
        }
        catch (InvalidCardChannelException | CardTerminalException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean isSscdActivated() throws SscdException, CardTerminalException {
        byte[] sw = this.selectDsDf();
        if (sw[0] == -112 && sw[1] == 0) {
            return true;
        }
        if (sw[0] == 98 && sw[1] == -125) {
            return false;
        }
        if (sw[0] == 98 && sw[1] == -126) {
            return false;
        }
        throw new SscdException("DS_DF not activated but not locked as well.");
    }

    @Override
    public boolean unblockRadPin(byte[] newPin) throws SscdException {
        try {
            this.allocateCardChannel();
            CardChannel cc = this.establishAppletConnection();
            boolean bl = this.unblockRadPin(cc, newPin);
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseCardChannel();
        }
        return false;
    }

    private boolean unblockRadPin(CardChannel cc, byte[] newPin) throws SscdException {
        ISOCommandAPDU capdu = new ISOCommandAPDU(0, 44, 2, -126, newPin);
        try {
            ResponseAPDU rsp = MWUtil.sendCommandAPDU(capdu, cc);
            if (rsp.sw() != 36864) {
                throw new SscdException(rsp.sw());
            }
            return true;
        }
        catch (InvalidCardChannelException | CardTerminalException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean verifyRadPin(byte[] pin) throws SscdException {
        try {
            this.allocateCardChannel();
            CardChannel cc = this.establishAppletConnection();
            boolean bl = this.verifyRadPin(cc, pin);
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseCardChannel();
        }
        return false;
    }

    @Override
    public boolean verifyUserPin(byte[] pin) throws SscdException {
        try {
            this.allocateCardChannel();
            CardChannel cc = this.establishAppletConnection();
            boolean bl = this.verifyUserPin(cc, pin);
            return bl;
        }
        catch (SscdException e) {
            e.printStackTrace();
            throw new SscdException("PIN verification failed. " + e.getMessage(), e.getSw());
        }
        catch (CardTerminalException e) {
            throw new SscdException("PIN verification failed. " + e.getMessage());
        }
        finally {
            this.releaseCardChannel();
        }
    }

    public boolean verifyUserPin(CardChannel cc, byte[] pin) throws SscdException, CardTerminalException {
        this.selectPki(cc);
        ISOCommandAPDU capdu = new ISOCommandAPDU(0, 32, 0, -127, pin);
        try {
            ResponseAPDU rsp = MWUtil.sendCommandAPDU(capdu, cc);
            if (rsp.sw() != 36864) {
                throw new SscdException(rsp.sw());
            }
            return true;
        }
        catch (InvalidCardChannelException | CardTerminalException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public byte[] selectEfTokenInfo() throws SscdException, CardTerminalException {
        try {
            this.allocateCardChannel();
            CardChannel cc = this.establishAppletConnection();
            byte[] byArray = this.selectEfTokenInfo(cc);
            return byArray;
        }
        finally {
            this.releaseCardChannel();
        }
    }

    private byte[] selectEfTokenInfo(CardChannel cc) throws SscdException, CardTerminalException {
        CommandAPDU capdu = new CommandAPDU(50);
        capdu.append((byte)0);
        capdu.append((byte)-92);
        capdu.append((byte)2);
        capdu.append((byte)0);
        capdu.append((byte)2);
        capdu.append(ConstantsSscd.EF_TOKENINFO[0]);
        capdu.append(ConstantsSscd.EF_TOKENINFO[1]);
        ResponseAPDU rsp = MWUtil.sendCommandAPDU(capdu, cc);
        if (rsp.sw() != 36864 && rsp.sw() != 25219) {
            if (rsp.sw() == 27010) {
                throw new SscdException("Security Conditions not satisfied (0x" + Integer.toHexString(rsp.sw()) + ")");
            }
            if (rsp.sw() == 27016) {
                throw new SscdException("Secure Channel not available (0x" + Integer.toHexString(rsp.sw()) + ")");
            }
            throw new SscdException("Could not select file (0x" + Integer.toHexString(rsp.sw()) + ")");
        }
        byte[] sw = new byte[]{rsp.sw1(), rsp.sw2()};
        return sw;
    }

    @Override
    public byte[] selectADF() throws SscdException, CardTerminalException {
        try {
            this.allocateCardChannel();
            CardChannel cc = this.establishAppletConnection();
            byte[] byArray = this.selectADF(cc);
            return byArray;
        }
        finally {
            this.releaseCardChannel();
        }
    }

    private byte[] selectADF(CardChannel cc) throws CardTerminalException, SscdException {
        CommandAPDU capdu = new CommandAPDU(50);
        byte[] adf = new byte[]{-24, 40, -67, 8, 15, -46, 80, 71, 101, 110, 101, 114, 105, 99};
        capdu.append((byte)0);
        capdu.append((byte)-92);
        capdu.append((byte)4);
        capdu.append((byte)12);
        capdu.append((byte)14);
        capdu.append(adf);
        ResponseAPDU rsp = MWUtil.sendCommandAPDU(capdu, cc);
        if (rsp.sw() != 36864) {
            if (rsp.sw() == 27010) {
                throw new SscdException("Security Conditions not satisfied (0x" + Integer.toHexString(rsp.sw()) + ")");
            }
            if (rsp.sw() == 27016) {
                throw new SscdException("Secure Channel not available (0x" + Integer.toHexString(rsp.sw()) + ")");
            }
            throw new SscdException("Could not select ADF (0x" + Integer.toHexString(rsp.sw()) + ")");
        }
        byte[] sw = new byte[]{rsp.sw1(), rsp.sw2()};
        return sw;
    }

    @Override
    public byte[] readSerialNumber() throws SscdException, CardTerminalException {
        try {
            this.allocateCardChannel();
            CardChannel cc = this.establishAppletConnection();
            byte[] byArray = this.readSerialNumber(cc);
            return byArray;
        }
        finally {
            this.releaseCardChannel();
        }
    }

    private byte[] readSerialNumber(CardChannel cc) throws CardTerminalException, SscdException {
        this.cardSerialNumberFromEfSn = this.getSn(cc);
        this.cardSerialNumberFromEfSn = Arrays.copyOfRange((byte[])this.cardSerialNumberFromEfSn, (int)0, (int)(this.cardSerialNumberFromEfSn.length - 2));
        return this.cardSerialNumberFromEfSn;
    }

    @Override
    public boolean verifyUserPuk(byte[] puk) throws SscdException {
        try {
            this.allocateCardChannel();
            CardChannel cc = this.establishAppletConnection();
            boolean bl = this.verifyUserPuk(cc, puk);
            return bl;
        }
        catch (SscdException e) {
            e.printStackTrace();
            throw new SscdException("PUK verification failed. " + e.getMessage(), e.getSw());
        }
        catch (CardTerminalException e) {
            e.printStackTrace();
            throw new SscdException("PUK verification failed. " + e.getMessage());
        }
        finally {
            this.releaseCardChannel();
        }
    }

    public boolean verifyUserPuk(CardChannel cc, byte[] puk) throws SscdException, CardTerminalException {
        byte[] byArray = new byte[2];
        byArray[0] = 63;
        byte[] rootFid = byArray;
        CommandAPDU capdu = new CommandAPDU(50);
        capdu = new ISOCommandAPDU(0, -92, 0, 0, rootFid);
        ResponseAPDU rsp = MWUtil.sendCommandAPDU(capdu, cc);
        if (rsp.sw() != 36864) {
            throw new SscdException("Could not select root file " + rsp.sw());
        }
        this.selectADF(cc);
        this.selectPki(cc);
        capdu = new ISOCommandAPDU(0, 32, 0, -126, puk);
        try {
            rsp = MWUtil.sendCommandAPDU(capdu, cc);
            if (rsp.sw() != 36864) {
                throw new SscdException(rsp.sw());
            }
            return true;
        }
        catch (InvalidCardChannelException | CardTerminalException e) {
            e.printStackTrace();
            return false;
        }
    }
}

