/*
 * Decompiled with CFR 0.152.
 */
package de.muehlbauer.mw.util;

import de.muehlbauer.mw.egov.ifc.DataGroup;
import de.muehlbauer.mw.egov.ifc.EgovCardServiceFactory;
import de.muehlbauer.mw.egov.ifc.EgovCardServiceInterface;
import de.muehlbauer.mw.egov.ifc.EgovException;
import de.muehlbauer.mw.protocol.container.PACEInfo;
import de.muehlbauer.mw.util.securechannel.MBSecureChannel;
import de.muehlbauer.mw.util.securechannel.SecureChannelProtocol;
import java.io.IOException;
import java.util.Vector;
import opencard.core.service.CHVDialog;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceRegistry;
import opencard.core.service.SmartCard;

public class MBMiddleware {
    private EgovCardServiceInterface egovifc = null;

    public MBMiddleware(EgovCardServiceInterface egovifc) {
        this.egovifc = egovifc;
    }

    public MBMiddleware(SmartCard sc) {
        EgovCardServiceInterface egovifc;
        CardServiceRegistry.getRegistry().add((CardServiceFactory)new EgovCardServiceFactory());
        try {
            egovifc = (EgovCardServiceInterface)sc.getCardService(EgovCardServiceInterface.class, true);
        }
        catch (Exception e) {
            egovifc = null;
        }
        this.egovifc = egovifc;
    }

    public boolean hasEgovApplet() {
        return this.egovifc != null;
    }

    public String[] getPresentApps() {
        Vector<String> presentApps = new Vector<String>();
        if (this.hasEgovApplet()) {
            presentApps.add("eGov");
        }
        return presentApps.toArray(new String[presentApps.size()]);
    }

    public String getAID(String appletName) {
        switch (appletName) {
            case "EGOV": {
                return "XXXXX";
            }
        }
        return "F000000003";
    }

    public EgovCardServiceInterface getEgovInterface() {
        return this.egovifc;
    }

    public void updateBinary(DataGroup dg, byte[] contents) throws EgovException {
    }

    public void disconnect() throws IOException {
    }

    public void verify(String pin, int keyId) throws IOException {
    }

    public void setCHVDialog(CHVDialog dialog) {
    }

    public PACEInfo authenticateSAC(String input, String keyIdentifier) throws IOException {
        if (this.egovifc != null) {
            return this.egovifc.authenticate(input, keyIdentifier);
        }
        throw new EgovException("MF Interface not found.");
    }

    public SecureChannelProtocol getActiveProtocol() {
        return MBSecureChannel.getInstance().getProtocol();
    }
}

