/*
 * Decompiled with CFR 0.152.
 */
package de.muehlbauer.mw.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import opencard.core.util.OpenCardConfigurationProvider;
import opencard.core.util.OpenCardPropertyLoadingException;

public class MBPropertyFileLoader
implements OpenCardConfigurationProvider {
    static Properties properties;

    protected void load(String location) {
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(location);
            Properties props = new Properties();
            if (is == null) {
                return;
            }
            props.load(is);
            properties = props;
            properties.setProperty("OpenCard.loaderClassName", this.getClass().getName());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadProperties() throws OpenCardPropertyLoadingException {
        if (properties == null) {
            String[] locations = new String[]{"mw.properties"};
            int index = 0;
            while (index < locations.length) {
                if (properties != null) break;
                this.load(locations[index]);
                ++index;
            }
            if (properties == null) {
                throw new OpenCardPropertyLoadingException("property file not found");
            }
        }
    }

    public Properties getProperties() {
        if (properties == null) {
            try {
                this.loadProperties();
            }
            catch (OpenCardPropertyLoadingException e) {
                throw new RuntimeException(e);
            }
        }
        return properties;
    }
}

