/*
 * Decompiled with CFR 0.152.
 */
package de.muehlbauer.mw.util;

import de.muehlbauer.mw.util.securechannel.MBSecureChannel;
import de.muehlbauer.mw.util.tlv.TLVTree;
import de.muehlbauer.mw.util.tlv.ToolsException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import opencard.core.service.CardChannel;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class MWUtil {
    private static final Properties PROPERTIES = new Properties();
    public static final int CARDTYPE_MF = 0;
    public static final int CARDTYPE_LDS = 1;
    public static final int CARDTYPE_IAS = 2;
    public static final int CARDTYPE_DL = 3;
    public static final int CARDTYPE_VR = 4;
    public static final int CARDTYPE_PAL = 5;
    public static final int CARDTYPE_GIDS = 6;
    public static final int CARDTYPE_GIDSADMIN = 7;

    static {
        try {
            PROPERTIES.load(MWUtil.class.getResourceAsStream("/mw.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int getLengthDG(byte[] firstBytesDG) {
        int tagLen = (firstBytesDG[0] & 0x1F) == 31 ? 2 : 1;
        int dataTagLen = (firstBytesDG[tagLen] & 0x80) == 128 ? firstBytesDG[tagLen] & 0xF : 0;
        int dataLen = 0;
        if (dataTagLen == 0) {
            dataLen = firstBytesDG[tagLen];
        } else {
            int i = 1;
            while (i <= dataTagLen) {
                dataLen <<= 8;
                dataLen += firstBytesDG[tagLen + i] & 0xFF;
                ++i;
            }
        }
        return dataLen + tagLen + dataTagLen + 1;
    }

    public static byte[] fetoOS(BigInteger value, int length) throws IOException {
        if (value.equals(BigInteger.ZERO) && length == 0) {
            return null;
        }
        BigInteger tmpValue = value;
        byte[] resultArray = new byte[length];
        BigInteger modValue = new BigInteger("256");
        if (modValue.pow(length).compareTo(value) <= 0) {
            throw new IOException("could not convert BigInteger to Byte with length L (length too small)");
        }
        int i = length - 1;
        while (i >= 0) {
            resultArray[i] = (byte)tmpValue.mod(modValue).intValue();
            tmpValue = tmpValue.divide(modValue);
            --i;
        }
        i = 1;
        while (modValue.pow(length - i).compareTo(value) == 1 && i < length) {
            if (modValue.pow(length - i).compareTo(value) != 1) break;
            resultArray[i - 1] = 0;
            ++i;
        }
        return resultArray;
    }

    public static boolean isNumeric(String s) {
        boolean isInteger = true;
        int i = 0;
        while (i < s.length() && isInteger) {
            char c = s.charAt(i);
            isInteger &= c >= '0' && c <= '9';
            ++i;
        }
        return isInteger;
    }

    public static byte[] toF2BArray(String password) throws IOException {
        int length = 8;
        byte[] passbytes = new byte[length];
        int i = 1;
        while (i < length) {
            passbytes[i] = -1;
            ++i;
        }
        i = 0;
        while (i < password.length() && i < 14) {
            char ch = password.charAt(i);
            if (ch < '0' && ch > '9') {
                throw new IOException("CHV must only contain digits");
            }
            passbytes[1 + (i >> 1)] = (i & 1) == 0 ? (byte)(ch - 48 << 4 | 0xF) : (byte)(passbytes[1 + (i >> 1)] & 0xF0 | ch - 48);
            ++i;
        }
        passbytes[0] = (byte)(0x20 | i);
        return passbytes;
    }

    public static boolean isWrongPinValue(int sw) {
        return (sw & 0xFFF0) == 25536;
    }

    public static ResponseAPDU sendCommandAPDU(CommandAPDU cmdAPDU, CardChannel cc) throws CardTerminalException {
        CommandAPDU capdu = cmdAPDU;
        if (MBSecureChannel.getInstance().isOpened() && !MBSecureChannel.getInstance().isCardReaderPace()) {
            capdu = MBSecureChannel.getInstance().wrap(cmdAPDU, 65535);
        }
        ResponseAPDU rsp = cc.sendCommandAPDU(capdu);
        if (MBSecureChannel.getInstance().isOpened() && !MBSecureChannel.getInstance().isCardReaderPace() && rsp.getLength() - 2 > 0) {
            rsp = MBSecureChannel.getInstance().unwrap(rsp, 65535);
        }
        return rsp;
    }

    public static SecretKey calculateBacKey(String docNr, String dateOfBirth, String dateOfExpiration, int keyNo) throws NoSuchAlgorithmException, NoSuchProviderException, IOException {
        byte[] derivationPostfix = new byte[3];
        MessageDigest md = MessageDigest.getInstance("SHA1", "BC");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(docNr.getBytes());
        bos.write(dateOfBirth.getBytes());
        bos.write(dateOfExpiration.getBytes());
        byte[] mrzdata = bos.toByteArray();
        byte[] hash = md.digest(mrzdata);
        bos.reset();
        byte[] hash_trunked = new byte[16];
        System.arraycopy(hash, 0, hash_trunked, 0, hash_trunked.length);
        bos.write(hash_trunked);
        bos.write(derivationPostfix);
        bos.write(keyNo);
        hash = md.digest(bos.toByteArray());
        System.arraycopy(hash, 0, hash_trunked, 0, hash_trunked.length);
        return new SecretKeySpec(hash_trunked, "DESede");
    }

    public static byte[] hexToByte(String input) {
        return HexString.parseHexString((String)input);
    }

    public static String byteToHex(byte[] input) {
        return HexString.hexify((byte[])input);
    }

    public static String extractAAAlgFromDG15(byte[] dg15) throws ToolsException {
        TLVTree dg15tlv = new TLVTree(dg15);
        byte[] rsaOID = new byte[]{42, -122, 72, -122, -9, 13, 1, 1, 1};
        byte[] ecOID = new byte[]{42, -122, 72, -50, 61, 2, 1};
        Vector<TLVTree> childTLV = dg15tlv.getChildren();
        for (TLVTree child : childTLV) {
            if (child.getTag() != 48) continue;
            Vector<TLVTree> childchildTLV = child.getChildren();
            for (TLVTree childchild : childchildTLV) {
                if (childchild.getTag() != 48) continue;
                Vector<TLVTree> childchildchildTLV = childchild.getChildren();
                for (TLVTree childchildchild : childchildchildTLV) {
                    if (childchildchild.getTag() != 6) continue;
                    byte[] algoid = childchildchild.getValue();
                    if (Arrays.equals(algoid, rsaOID)) {
                        return "RSA";
                    }
                    if (Arrays.equals(algoid, ecOID)) {
                        return "EC";
                    }
                    throw new ToolsException("Unknown Algorithm OID: ");
                }
            }
        }
        throw new ToolsException("Could not find AA Algorithm");
    }

    public static byte[] getPlainSignatureAA_RSA(byte[] aaPubkeyByte, byte[] encSig) {
        byte[] plain = null;
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("RSA/ECB/NoPadding", (Provider)new BouncyCastleProvider());
            TLVTree tlvt = new TLVTree(aaPubkeyByte);
            BigInteger modulus = new BigInteger(tlvt.getChildren().get(0).getValue());
            BigInteger exponent = new BigInteger(tlvt.getChildren().get(1).getValue());
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(modulus, exponent);
            KeyFactory fact = KeyFactory.getInstance("RSA");
            PublicKey aaPubKey = fact.generatePublic(keySpec);
            cipher.init(2, aaPubKey);
            plain = cipher.doFinal(encSig);
            return plain;
        }
        catch (Exception e) {
            e.printStackTrace();
            return plain;
        }
    }

    public static boolean verifyAASignatureRSA(byte[] plain, byte[] challengem2) throws IOException, NoSuchAlgorithmException {
        int m1Length = plain.length - 22;
        byte[] m1 = new byte[m1Length];
        System.arraycopy(plain, 1, m1, 0, m1Length);
        byte[] h = new byte[20];
        System.arraycopy(plain, m1Length + 1, h, 0, 20);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(m1);
        bos.write(challengem2);
        byte[] href = MessageDigest.getInstance("SHA1", (Provider)new BouncyCastleProvider()).digest(bos.toByteArray());
        return Arrays.equals(href, h);
    }

    public static ECPublicKey ConvertToECPubKey(byte[] pubKey, ECParameterSpec paramSpec) throws NoSuchAlgorithmException, InvalidKeySpecException {
        int offset = 0;
        if (pubKey.length % 2 == 1 && pubKey[0] == 4) {
            offset = 1;
        }
        int keySizeByte = (paramSpec.getOrder().bitLength() + 7) / 8;
        byte[] bX = new byte[keySizeByte];
        byte[] bY = new byte[keySizeByte];
        try {
            System.arraycopy(pubKey, offset, bX, 0, keySizeByte);
            System.arraycopy(pubKey, keySizeByte + offset, bY, 0, keySizeByte);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            keySizeByte = pubKey.length / 2;
            bX = new byte[keySizeByte];
            bY = new byte[keySizeByte];
            System.arraycopy(pubKey, offset, bX, 0, keySizeByte);
            System.arraycopy(pubKey, keySizeByte + offset, bY, 0, keySizeByte);
        }
        BigInteger x = new BigInteger(1, bX);
        BigInteger y = new BigInteger(1, bY);
        ECPoint w = new ECPoint(x, y);
        ECPublicKeySpec newKeySpec = new ECPublicKeySpec(w, paramSpec);
        KeyFactory keyFactory = KeyFactory.getInstance("EC", (Provider)new BouncyCastleProvider());
        ECPublicKey resultPubKey = (ECPublicKey)keyFactory.generatePublic(newKeySpec);
        return resultPubKey;
    }

    public static ECPrivateKey ConvertToECPrivKey(byte[] pivKey, ECParameterSpec paramSpec) throws NoSuchAlgorithmException, InvalidKeySpecException {
        int offset = 0;
        if (pivKey.length % 2 == 1 && pivKey[0] == 4) {
            offset = 1;
        }
        int keySizeByte = paramSpec.getOrder().bitLength() / 8;
        byte[] bX = new byte[keySizeByte];
        byte[] bY = new byte[keySizeByte];
        try {
            System.arraycopy(pivKey, offset, bX, 0, keySizeByte);
            System.arraycopy(pivKey, keySizeByte + offset, bY, 0, keySizeByte);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            keySizeByte = pivKey.length / 2;
            bX = new byte[keySizeByte];
            bY = new byte[keySizeByte];
            System.arraycopy(pivKey, offset, bX, 0, keySizeByte);
            System.arraycopy(pivKey, keySizeByte + offset, bY, 0, keySizeByte);
        }
        BigInteger x = new BigInteger(1, bX);
        ECPrivateKeySpec newprivkeyspec = new ECPrivateKeySpec(x, paramSpec);
        KeyFactory keyFactory = KeyFactory.getInstance("EC", (Provider)new BouncyCastleProvider());
        ECPrivateKey resultPubKey = (ECPrivateKey)keyFactory.generatePrivate(newprivkeyspec);
        return resultPubKey;
    }

    public static byte[] GetUncompressedKey(ECPublicKey pubkey) throws IOException {
        Throwable throwable = null;
        Object var2_4 = null;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int i;
            byte[] xVal = pubkey.getW().getAffineX().toByteArray();
            byte[] yVal = pubkey.getW().getAffineY().toByteArray();
            int keyLength = (pubkey.getParams().getOrder().bitLength() + 7) / 8;
            if (xVal.length == keyLength + 1) {
                byte[] xValTmp = new byte[keyLength];
                System.arraycopy(xVal, 1, xValTmp, 0, xValTmp.length);
                xVal = xValTmp;
            }
            if (yVal.length == keyLength + 1) {
                byte[] yValTmp = new byte[yVal.length - 1];
                System.arraycopy(yVal, 1, yValTmp, 0, yValTmp.length);
                yVal = yValTmp;
            }
            if (xVal.length < keyLength) {
                bos.reset();
                int difference = keyLength - xVal.length;
                i = 0;
                while (i < difference) {
                    bos.write(0);
                    ++i;
                }
                bos.write(xVal);
                xVal = bos.toByteArray();
            }
            if (yVal.length < keyLength) {
                bos.reset();
                int difference = keyLength - yVal.length;
                i = 0;
                while (i < difference) {
                    bos.write(0);
                    ++i;
                }
                bos.write(yVal);
                yVal = bos.toByteArray();
            }
            bos.reset();
            bos.write(4);
            bos.write(xVal);
            bos.write(yVal);
            return bos.toByteArray();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] GetCompressedKey(ECPublicKey pubkey) throws IOException {
        Throwable throwable = null;
        Object var2_4 = null;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] xVal = pubkey.getW().getAffineX().toByteArray();
            int keyLength = (pubkey.getParams().getOrder().bitLength() + 7) / 8;
            if (xVal.length == keyLength + 1) {
                byte[] xValTmp = new byte[keyLength];
                System.arraycopy(xVal, 1, xValTmp, 0, xValTmp.length);
                xVal = xValTmp;
            }
            if (xVal.length < keyLength) {
                bos.reset();
                int difference = keyLength - xVal.length;
                int i = 0;
                while (i < difference) {
                    bos.write(0);
                    ++i;
                }
                bos.write(xVal);
                xVal = bos.toByteArray();
            }
            return xVal;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] Get32Bit_BigEndian(byte[] c) {
        byte[] result = new byte[4];
        int i = 0;
        while (i < 4) {
            result[i] = c.length + i >= 4 ? c[c.length + i - 4] : (byte)0;
            ++i;
        }
        return result;
    }

    public static byte[] Get32Bit_BigEndian(byte c) {
        byte[] result = new byte[]{c};
        return MWUtil.Get32Bit_BigEndian(result);
    }
}

