/*
 * Decompiled with CFR 0.152.
 */
package de.muehlbauer.mw.util;

import de.muehlbauer.mw.egov.ifc.EgovException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OIDTable {
    private static HashMap<String, String> OIDTable = new HashMap();
    private static HashMap<Byte, String> ECDHCurveTable;

    static {
        OIDTable.put("0.4.0.127.0.7.2.2.4.1.1", "id-PACE-DH-GM-3DES-CBC-CBC");
        OIDTable.put("0.4.0.127.0.7.2.2.4.1.2", "id-PACE-DH-GM-AES-CBC-CMAC-128");
        OIDTable.put("0.4.0.127.0.7.2.2.4.1.3", "id-PACE-DH-GM-AES-CBC-CMAC-192");
        OIDTable.put("0.4.0.127.0.7.2.2.4.1.4", "id-PACE-DH-GM-AES-CBC-CMAC-256");
        OIDTable.put("0.4.0.127.0.7.2.2.4.2.1", "id-PACE-ECDH-GM-3DES-CBC-CBC");
        OIDTable.put("0.4.0.127.0.7.2.2.4.2.2", "id-PACE-ECDH-GM-AES-CBC-CMAC-128");
        OIDTable.put("0.4.0.127.0.7.2.2.4.2.3", "id-PACE-ECDH-GM-AES-CBC-CMAC-192");
        OIDTable.put("0.4.0.127.0.7.2.2.4.2.4", "id-PACE-ECDH-GM-AES-CBC-CMAC-256");
        OIDTable.put("0.4.0.127.0.7.2.2.4.3.1", "id-PACE-DH-IM-3DES-CBC-CBC");
        OIDTable.put("0.4.0.127.0.7.2.2.4.3.2", "id-PACE-DH-IM-AES-CBC-CMAC-128");
        OIDTable.put("0.4.0.127.0.7.2.2.4.3.3", "id-PACE-DH-IM-AES-CBC-CMAC-192");
        OIDTable.put("0.4.0.127.0.7.2.2.4.3.4", "id-PACE-DH-IM-AES-CBC-CMAC-256");
        OIDTable.put("0.4.0.127.0.7.2.2.4.4.1", "id-PACE-ECDH-IM-3DES-CBC-CBC");
        OIDTable.put("0.4.0.127.0.7.2.2.4.4.2", "id-PACE-ECDH-IM-AES-CBC-CMAC-128");
        OIDTable.put("0.4.0.127.0.7.2.2.4.4.3", "id-PACE-ECDH-IM-AES-CBC-CMAC-192");
        OIDTable.put("0.4.0.127.0.7.2.2.4.4.4", "id-PACE-ECDH-IM-AES-CBC-CMAC-256");
        OIDTable.put("0.4.0.127.0.7.2.2.4.6.2", "id-PACE-ECDH-CAM-AES-CBC-CMAC-128");
        OIDTable.put("0.4.0.127.0.7.2.2.4.6.3", "id-PACE-ECDH-CAM-AES-CBC-CMAC-192");
        OIDTable.put("0.4.0.127.0.7.2.2.4.6.4", "id-PACE-ECDH-CAM-AES-CBC-CMAC-256");
        OIDTable.put("0.4.0.127.0.7.2.2.3", "CA");
        OIDTable.put("0.4.0.127.0.7.2.2.3.1", "CA-DH");
        OIDTable.put("0.4.0.127.0.7.2.2.3.1.1", "CA-DH-3DES-CBC-CBC");
        OIDTable.put("0.4.0.127.0.7.2.2.3.1.2", "CA-DH-AES-CBC-CMAC-128");
        OIDTable.put("0.4.0.127.0.7.2.2.3.1.3", "CA-DH-AES-CBC-CMAC-192");
        OIDTable.put("0.4.0.127.0.7.2.2.3.1.4", "CA-DH-AES-CBC-CMAC-256");
        OIDTable.put("0.4.0.127.0.7.2.2.3.2", "CA-ECDH");
        OIDTable.put("0.4.0.127.0.7.2.2.3.2.1", "CA-ECDH-3DES-CBC-CBC");
        OIDTable.put(" 0.4.0.127.0.7.2.2.3.2.2", "CA-ECDH-AES-CBC-CMAC-128");
        OIDTable.put("0.4.0.127.0.7.2.2.3.2.3", "CA-ECDH-AES-CBC-CMAC-192");
        OIDTable.put("0.4.0.127.0.7.2.2.3.2.4", "CA-ECDH-AES-CBC-CMAC-256");
        OIDTable.put("1.2.840.113549.1.1.1", "RSA");
        OIDTable.put("1.2.840.10045.2.1", "EC Public Key");
        ECDHCurveTable = new HashMap();
        ECDHCurveTable.put((byte)8, "secp192r1");
        ECDHCurveTable.put((byte)9, "BrainpoolP192r1");
        ECDHCurveTable.put((byte)10, "secp224r1");
        ECDHCurveTable.put((byte)11, "BrainpoolP224r1");
        ECDHCurveTable.put((byte)12, "secp256r1");
        ECDHCurveTable.put((byte)13, "BrainpoolP256r1");
        ECDHCurveTable.put((byte)14, "BrainpoolP320r1");
        ECDHCurveTable.put((byte)15, "secp384r1");
        ECDHCurveTable.put((byte)16, "BrainpoolP384r1");
        ECDHCurveTable.put((byte)17, "BrainpoolP512r1");
        ECDHCurveTable.put((byte)18, "secp521r1");
    }

    protected OIDTable() {
    }

    public static String GetAlgorithm(String tlv) throws EgovException {
        Set<String> keySet = OIDTable.keySet();
        for (String oid : keySet) {
            if (!tlv.contains(oid)) continue;
            return oid;
        }
        throw new EgovException("SAC not supported");
    }

    public static String GetECCurve(byte id) {
        return ECDHCurveTable.get(id);
    }

    public static byte[] OID2Byte(String oid) {
        if (oid == null || oid.isEmpty()) {
            throw new IllegalArgumentException("OID not set");
        }
        String[] split = oid.trim().split("\\.");
        ArrayList<Integer> retVal = new ArrayList<Integer>();
        int a = 0;
        int b = 0;
        int i = 0;
        while (i < split.length) {
            if (i == 0) {
                a = Integer.parseInt(split[0]);
            } else if (i == 1) {
                retVal.add(40 * a + Integer.parseInt(split[1]));
            } else {
                b = Integer.parseInt(split[i]);
                if (b < 128) {
                    retVal.add(b);
                } else {
                    retVal.add(128 + b / 128);
                    retVal.add(b % 128);
                }
            }
            ++i;
        }
        byte[] temp = new byte[retVal.size()];
        int i2 = 0;
        while (i2 < retVal.size()) {
            temp[i2] = ((Integer)retVal.get(i2)).byteValue();
            ++i2;
        }
        return temp;
    }

    public static String ReadableOIDToOid(String readableOID) {
        if (!OIDTable.containsValue(readableOID)) {
            throw new IllegalArgumentException("Could not find " + readableOID);
        }
        for (Map.Entry<String, String> entry : OIDTable.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!value.equals(readableOID)) continue;
            return key;
        }
        throw new IllegalArgumentException("Could not find " + readableOID);
    }

    public static HashMap<String, String> getOIDTableMap() {
        return OIDTable;
    }
}

