/*
 * Decompiled with CFR 0.152.
 */
package de.muehlbauer.mw.util.securechannel;

import de.cardcontact.opencard.security.IsoSecureChannel;
import de.muehlbauer.mw.util.securechannel.SecureChannelProtocol;
import javax.crypto.SecretKey;

public class MBSecureChannel
extends IsoSecureChannel {
    private SecureChannelProtocol m_protocol;
    private static MBSecureChannel instance = null;
    private boolean m_isOpened = false;
    private boolean m_isCardReaderPace = false;

    protected MBSecureChannel() {
    }

    public static synchronized MBSecureChannel getInstance() {
        if (instance == null) {
            instance = new MBSecureChannel();
        }
        return instance;
    }

    public void reset() {
        this.m_isOpened = false;
        this.m_isCardReaderPace = false;
        this.m_protocol = null;
        this.setMACSendSequenceCounter(null);
        instance = null;
    }

    public boolean keyTypeEquals(String keyType) {
        int protocolID = MBSecureChannel.getInstance().getProtocol().getId();
        if (keyType.toLowerCase().equals("mrz") && protocolID == 1) {
            return true;
        }
        if (keyType.toLowerCase().equals("can") && protocolID == 2) {
            return true;
        }
        if (keyType.toLowerCase().equals("pin") && protocolID == 3) {
            return true;
        }
        if (keyType.toLowerCase().equals("puk") && protocolID == 4) {
            return true;
        }
        return keyType.toLowerCase().equals("admin") && protocolID == 8;
    }

    public void setOpened(boolean isOpened) {
        this.m_isOpened = isOpened;
    }

    public boolean isOpened() {
        return this.m_isOpened;
    }

    public boolean isCardReaderPace() {
        return this.m_isCardReaderPace;
    }

    public void setCardReaderPace(boolean isCardReaderPace) {
        this.m_isCardReaderPace = isCardReaderPace;
    }

    public void setIV(byte[] iv) {
        this.iv = iv;
    }

    public static void openSecureChannel(SecretKey kenc, SecretKey kmac, SecureChannelProtocol protocol, byte[] ssc) {
        instance = null;
        if (kenc.getAlgorithm().equals("AES")) {
            MBSecureChannel.getInstance().setSendSequenceCounterPolicy(IsoSecureChannel.SSCPolicyEnum.SYNC_AND_ENCRYPT);
        }
        MBSecureChannel.getInstance().setEncKey(kenc);
        MBSecureChannel.getInstance().setMacKey(kmac);
        if (ssc != null) {
            MBSecureChannel.getInstance().setMACSendSequenceCounter(ssc);
        } else if (kenc.getAlgorithm().equals("AES")) {
            MBSecureChannel.getInstance().setMACSendSequenceCounter(new byte[16]);
        } else {
            MBSecureChannel.getInstance().setMACSendSequenceCounter(new byte[8]);
        }
        MBSecureChannel.getInstance().setProtocol(protocol);
        MBSecureChannel.getInstance().setCardReaderPace(false);
        MBSecureChannel.getInstance().setOpened(true);
    }

    public SecureChannelProtocol getProtocol() {
        return this.m_protocol;
    }

    public void setProtocol(SecureChannelProtocol m_protocol) {
        this.m_protocol = m_protocol;
    }
}

