/*
 * Decompiled with CFR 0.152.
 */
package de.muehlbauer.mw.util.tlv;

import de.muehlbauer.mw.util.tlv.ToolsException;
import java.util.Calendar;

public class MBTools {
    public static final int TEXTFORMAT_DATE = 0;
    public static final int TEXTFORMAT_DATEANDTIME = 1;

    public static byte[] DES2toDES3(byte[] DES2Key) {
        if (DES2Key.length < 16) {
            return null;
        }
        if (DES2Key.length == 24) {
            return DES2Key;
        }
        byte[] result = new byte[24];
        System.arraycopy(DES2Key, 0, result, 0, 16);
        System.arraycopy(DES2Key, 0, result, 16, 8);
        return result;
    }

    public static byte[] HexToBytes(String s) throws ToolsException {
        byte[] Result = new byte[s.length() / 2];
        int i = 0;
        while (i < s.length() - 1) {
            int k = 0;
            int j = s.charAt(i);
            if (j >= 65 && j <= 70) {
                j = j + 10 - 65;
            } else if (j >= 97 && j <= 102) {
                j = j + 10 - 97;
            } else if (j >= 48 && j <= 57) {
                j -= 48;
            } else {
                throw new ToolsException("toBytes(String):\"" + s + "\" is not valid");
            }
            k = j << 4;
            j = s.charAt(i + 1);
            if (j >= 65 && j <= 70) {
                j = j + 10 - 65;
            } else if (j >= 97 && j <= 102) {
                j = j + 10 - 97;
            } else if (j >= 48 && j <= 57) {
                j -= 48;
            } else {
                throw new ToolsException("toBytes(String):\"" + s + "\" is not valid");
            }
            Result[i / 2] = (byte)(k |= j);
            i += 2;
        }
        return Result;
    }

    public static byte[] HexToBytes_NoEx(String string) {
        try {
            return MBTools.HexToBytes(string);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static String BytesToHex(byte[] data) {
        String s = new String();
        int i = 0;
        while (i < data.length) {
            int j = data[i] >> 4 & 0xF;
            j = j < 10 ? (j += 48) : j - 10 + 65;
            s = String.valueOf(s) + (char)j;
            j = data[i] & 0xF;
            j = j < 10 ? (j += 48) : j - 10 + 65;
            s = String.valueOf(s) + (char)j;
            ++i;
        }
        return s;
    }

    public static String BytesToHex(byte[] data, int offset, int nLen) {
        String s = new String();
        int i = 0;
        while (i < nLen) {
            int j = data[i + offset] >> 4 & 0xF;
            j = j < 10 ? (j += 48) : j - 10 + 65;
            s = String.valueOf(s) + (char)j;
            j = data[i + offset] & 0xF;
            j = j < 10 ? (j += 48) : j - 10 + 65;
            s = String.valueOf(s) + (char)j;
            ++i;
        }
        return s;
    }

    public static long BytesToLong(byte[] data) throws ToolsException {
        if (data.length > 8) {
            throw new ToolsException("toLong(byte[]): input array too big!");
        }
        long l = 0L;
        int i = 0;
        while (i < data.length) {
            l <<= 8;
            l |= (long)data[i] & 0xFFL;
            ++i;
        }
        return l;
    }

    public static int BytesToInt(byte[] data) throws ToolsException {
        if (data.length > 4) {
            throw new ToolsException("toInt(byte[]): input array too big!");
        }
        int l = 0;
        int i = 0;
        while (i < data.length) {
            l <<= 8;
            l |= data[i] & 0xFF;
            ++i;
        }
        return l;
    }

    public static int BytesToInt(byte[] b, int offset) {
        int value = 0;
        int i = 0;
        while (i < 4) {
            int shift = i * 8;
            value += (b[i + offset] & 0xFF) << shift;
            ++i;
        }
        return value;
    }

    public static short BytesToShort(byte[] data, int offset) throws ToolsException {
        if (data.length - offset < 2) {
            throw new ToolsException("toShort(byte[], int): input array too small!");
        }
        short l = 0;
        int i = 0;
        while (i < 2) {
            l = (short)(l << 8);
            l = (short)(l | (short)data[offset + i] & 0xFF);
            ++i;
        }
        return l;
    }

    public static short BytesToShort(byte[] data) throws ToolsException {
        if (data.length > 2) {
            throw new ToolsException("toShort(byte[]): input array too big!");
        }
        return MBTools.BytesToShort(data, 0);
    }

    public static void ShortToBytes(short s, byte[] data, int offset) {
        data[offset] = (byte)(s >> 8 & 0xFF);
        data[offset + 1] = (byte)(s & 0xFF);
    }

    public static byte[] LongToBytes(long l) {
        byte[] Result = new byte[8];
        int i = 7;
        while (i >= 0) {
            Result[7 - i] = (byte)(l >> i * 8);
            --i;
        }
        return Result;
    }

    public static boolean IsEqual(byte[] a1, byte[] a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a1.length) {
            if (a1[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static byte[] setDESParity(byte[] inData) {
        if (inData == null) {
            return null;
        }
        byte[] outData = new byte[inData.length];
        int i = 0;
        while (i < inData.length) {
            int bitCount = 0;
            int j = 7;
            while (j > 0) {
                if ((inData[i] & 1 << j) != 0) {
                    ++bitCount;
                }
                --j;
            }
            outData[i] = bitCount % 2 != 0 ? (byte)(inData[i] & 0xFE) : (byte)(inData[i] | 1);
            ++i;
        }
        return outData;
    }

    public static String CalendarToString(Calendar c, int textformat, boolean withTimezone) {
        String formatString = null;
        switch (textformat) {
            case 0: {
                formatString = "%1$tY-%1$tm-%1$td";
                break;
            }
            case 1: {
                formatString = "%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS";
                break;
            }
            default: {
                return null;
            }
        }
        if (withTimezone) {
            formatString = String.valueOf(formatString) + " " + c.getTimeZone().getDisplayName();
        }
        return String.format(formatString, c);
    }

    public static boolean IsEqual(char[] c1, char[] c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null) {
            return false;
        }
        if (c2 == null) {
            return false;
        }
        if (c1.length != c2.length) {
            return false;
        }
        int i = 0;
        while (i < c1.length) {
            if (c1[i] != c2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static byte[] CharsToBytes(char[] c) {
        byte[] b = new byte[c.length];
        int i = 0;
        while (i < c.length) {
            b[i] = (byte)c[i];
            ++i;
        }
        return b;
    }

    public static byte[] fixArraySize(byte[] in, int size) {
        byte[] out = new byte[size];
        int inOff = 0;
        int outOff = 0;
        int copyLen = 0;
        int i = 0;
        while (i < out.length - in.length) {
            out[outOff++] = 0;
            ++i;
        }
        if (in.length > out.length) {
            inOff = in.length - out.length;
            copyLen = out.length;
        } else {
            copyLen = in.length;
        }
        System.arraycopy(in, inOff, out, outOff, copyLen);
        return out;
    }
}

