/*
 * Decompiled with CFR 0.152.
 */
package de.muehlbauer.mw.util.tlv;

import de.muehlbauer.mw.util.tlv.IntWrapper;
import de.muehlbauer.mw.util.tlv.MBTools;
import de.muehlbauer.mw.util.tlv.ToolsException;
import java.util.Vector;

public class TLVTree {
    private final int m_Tag;
    private byte[] m_Value;
    private Vector<TLVTree> m_Children;

    public TLVTree() {
        this.m_Tag = 0;
        this.m_Value = new byte[0];
    }

    public static int ReadBERLength(byte[] data, IntWrapper offset) throws ToolsException {
        if (data.length <= offset.value) {
            throw new ToolsException("TLV structure invalid: length byte not available");
        }
        int result = data[offset.value];
        if (result >= 0) {
            ++offset.value;
            return result;
        }
        int NoOfLengthBytes = data[offset.value] & 0x7F;
        ++offset.value;
        result = 0;
        while (NoOfLengthBytes > 0) {
            int nextbyte;
            if (data.length <= offset.value) {
                throw new ToolsException("TLV structure invalid: length byte not available");
            }
            if ((nextbyte = data[offset.value++]) < 0) {
                nextbyte += 256;
            }
            result <<= 8;
            result |= nextbyte;
            --NoOfLengthBytes;
        }
        return result;
    }

    static int ReadTag(byte[] data, IntWrapper offset) throws ToolsException {
        int nextbyte;
        int thisbyte;
        if (data.length <= offset.value) {
            throw new ToolsException("TLV structure invalid: length byte not available");
        }
        if ((thisbyte = data[offset.value++]) < 0) {
            thisbyte += 256;
        }
        if (!TLVTree.isTwoByteTag(thisbyte)) {
            return thisbyte;
        }
        if ((nextbyte = data[offset.value++]) < 0) {
            nextbyte += 256;
        }
        return thisbyte << 8 | nextbyte;
    }

    public static byte[] WriteBERLength(int nLen) {
        int nCheckVal = 0;
        int nByteCount = 1;
        nCheckVal |= 0xFF;
        while (nCheckVal < nLen) {
            ++nByteCount;
            nCheckVal <<= 8;
        }
        if (nByteCount == 1 && nLen <= 127) {
            byte[] Result = new byte[]{(byte)(nLen & 0x7F)};
            return Result;
        }
        byte[] Result = new byte[nByteCount + 1];
        Result[0] = (byte)(128 + nByteCount);
        int i = 0;
        while (i < nByteCount) {
            Result[nByteCount - i] = (byte)(nLen & 0xFF);
            nLen >>= 8;
            ++i;
        }
        return Result;
    }

    public static byte[] TagToBytes(int Tag) {
        if (TLVTree.isTwoByteTag(Tag)) {
            byte[] result = new byte[]{(byte)(Tag >> 8 & 0xFF), (byte)(Tag >> 0 & 0xFF)};
            return result;
        }
        byte[] result = new byte[]{(byte)(Tag >> 0 & 0xFF)};
        return result;
    }

    public static boolean isTwoByteTag(int Tag) {
        int x = Tag;
        if ((x & 0xFF00) > 0) {
            x >>= 8;
        }
        return (x & 0x1F) == 31;
    }

    public static boolean isConstructed(int Tag) {
        int x = Tag;
        if ((x & 0xFF00) > 0) {
            x >>= 8;
        }
        return (x & 0x20) == 32;
    }

    public TLVTree(byte[] data, IntWrapper offset) throws ToolsException {
        if (data.length <= offset.value) {
            throw new ToolsException("TLV Structure Invalid: no more bytes to read tags");
        }
        this.m_Tag = TLVTree.ReadTag(data, offset);
        int dataLength = TLVTree.ReadBERLength(data, offset);
        if (offset.value + dataLength > data.length) {
            throw new ToolsException("TLV Structure Invalid: not enough bytes to read data");
        }
        if (TLVTree.isConstructed(this.m_Tag) && this.m_Tag != 65292) {
            this.m_Children = new Vector();
            int MySequenceEnd = offset.value + dataLength;
            while (offset.value < MySequenceEnd) {
                TLVTree t = new TLVTree(data, offset);
                this.m_Children.add(t);
            }
        } else {
            this.m_Value = new byte[dataLength];
            System.arraycopy(data, offset.value, this.m_Value, 0, dataLength);
            offset.value += dataLength;
        }
    }

    public TLVTree(byte[] data) throws ToolsException {
        this(data, new IntWrapper(0));
    }

    public TLVTree(int Tag, byte[] Value) {
        this.m_Tag = Tag;
        this.m_Value = Value;
    }

    public TLVTree(int Tag, TLVTree[] Children) {
        this.m_Tag = Tag;
        this.m_Children = new Vector();
        int i = 0;
        while (i < Children.length) {
            this.m_Children.add(Children[i]);
            ++i;
        }
    }

    public TLVTree(int Tag, TLVTree child) {
        this.m_Tag = Tag;
        this.m_Children = new Vector();
        this.m_Children.add(child);
    }

    public byte[] toBytes() {
        byte[][] localResult;
        int nTotalLength = 0;
        if (TLVTree.isConstructed(this.m_Tag) && this.m_Tag != 65292) {
            if (this.m_Children == null) {
                this.m_Children = new Vector();
            }
            localResult = new byte[this.m_Children.size() + 2][];
            int i = 0;
            while (i < this.m_Children.size()) {
                localResult[i + 2] = this.m_Children.elementAt(i).toBytes();
                nTotalLength += localResult[i + 2].length;
                ++i;
            }
            localResult[0] = TLVTree.TagToBytes(this.m_Tag);
            localResult[1] = TLVTree.WriteBERLength(nTotalLength);
            nTotalLength += localResult[0].length;
            nTotalLength += localResult[1].length;
        } else if (this.m_Value == null) {
            localResult = new byte[3][];
            nTotalLength = 0;
            localResult[0] = TLVTree.TagToBytes(this.m_Tag);
            localResult[1] = TLVTree.WriteBERLength(nTotalLength);
            localResult[2] = new byte[0];
            nTotalLength += localResult[0].length;
            nTotalLength += localResult[1].length;
        } else {
            localResult = new byte[3][];
            nTotalLength = this.m_Value.length;
            localResult[0] = TLVTree.TagToBytes(this.m_Tag);
            localResult[1] = TLVTree.WriteBERLength(nTotalLength);
            localResult[2] = this.m_Value;
            nTotalLength += localResult[0].length;
            nTotalLength += localResult[1].length;
        }
        byte[] Result = new byte[nTotalLength];
        int nOffset = 0;
        int i = 0;
        while (i < localResult.length) {
            System.arraycopy(localResult[i], 0, Result, nOffset, localResult[i].length);
            nOffset += localResult[i].length;
            ++i;
        }
        return Result;
    }

    public String toString() {
        String s = "<" + MBTools.BytesToHex(TLVTree.TagToBytes(this.m_Tag)) + ", ";
        if (TLVTree.isConstructed(this.m_Tag)) {
            s = String.valueOf(s) + "(";
            int i = 0;
            while (i < this.m_Children.size()) {
                if (i > 0) {
                    s = String.valueOf(s) + ", ";
                }
                s = String.valueOf(s) + this.m_Children.elementAt(i).toString();
                ++i;
            }
            s = String.valueOf(s) + ")";
        } else {
            s = String.valueOf(s) + MBTools.BytesToHex(this.m_Value);
        }
        s = String.valueOf(s) + ">";
        return s;
    }

    public int getTag() {
        return this.m_Tag;
    }

    public Vector<TLVTree> getChildren() {
        return this.m_Children;
    }

    public byte[] getValue() {
        return this.m_Value;
    }

    public void setValue(byte[] value) {
        this.m_Value = value;
    }

    static boolean Test() throws ToolsException {
        if (TLVTree.isConstructed(128)) {
            return false;
        }
        if (TLVTree.isConstructed(32768)) {
            return false;
        }
        if (!TLVTree.isConstructed(32)) {
            return false;
        }
        if (!TLVTree.isConstructed(16163)) {
            return false;
        }
        if (TLVTree.isTwoByteTag(96)) {
            return false;
        }
        if (TLVTree.isTwoByteTag(24576)) {
            return false;
        }
        if (!TLVTree.isTwoByteTag(159)) {
            return false;
        }
        if (!TLVTree.isTwoByteTag(40743)) {
            return false;
        }
        TLVTree.TagToBytes(128);
        TLVTree.TagToBytes(40739);
        byte[] x1 = new byte[]{127};
        TLVTree.ReadBERLength(x1, new IntWrapper(0));
        x1 = new byte[]{-127, -128};
        TLVTree.ReadBERLength(x1, new IntWrapper(0));
        x1 = new byte[]{-126, 1, 2};
        TLVTree.ReadBERLength(x1, new IntWrapper(0));
        TLVTree t1 = new TLVTree(128, MBTools.HexToBytes("0102030405"));
        TLVTree t2 = new TLVTree(MBTools.HexToBytes("50020000"));
        TLVTree t3 = new TLVTree(MBTools.HexToBytes("A00750020304510100"));
        TLVTree[] tx = new TLVTree[]{t1, t2, t3};
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TLVTree getSubTreeFromTagPath(byte[] tagPath, IntWrapper nOffset) {
        if (nOffset.value == tagPath.length) {
            return this;
        }
        try {
            int nExpectedTag;
            int nChildOffset = -1;
            do {
                if (nOffset.value >= tagPath.length) {
                    return this.m_Children.get(nChildOffset);
                }
                if (tagPath[nOffset.value] == -1) {
                    if (nChildOffset == -1) {
                        return null;
                    }
                    ++nOffset.value;
                    if (nOffset.value == tagPath.length) {
                        this.m_Children.get(nChildOffset);
                    }
                    return this.m_Children.get(nChildOffset).getSubTreeFromTagPath(tagPath, nOffset);
                }
                if (++nChildOffset < this.m_Children.size()) continue;
                return null;
            } while ((nExpectedTag = TLVTree.ReadTag(tagPath, nOffset)) == this.m_Children.get((int)nChildOffset).m_Tag);
            return null;
        }
        catch (ToolsException toolsException) {
            return null;
        }
    }

    public static TLVTree getSubTreeFromTagPath(byte[] tagPath, TLVTree t) {
        IntWrapper i;
        block8: {
            block7: {
                block6: {
                    try {
                        if (tagPath.length != 0) break block6;
                        return null;
                    }
                    catch (ToolsException toolsException) {
                        return null;
                    }
                }
                i = new IntWrapper(0);
                int nExpectedTag = TLVTree.ReadTag(tagPath, i);
                if (nExpectedTag == t.m_Tag) break block7;
                return null;
            }
            if (i.value == tagPath.length) {
                return t;
            }
            if (tagPath[i.value] == -1) break block8;
            return null;
        }
        ++i.value;
        return t.getSubTreeFromTagPath(tagPath, i);
    }

    public boolean equals(TLVTree other) {
        if (other == null) {
            return false;
        }
        if (this.m_Tag != other.m_Tag) {
            return false;
        }
        if (TLVTree.isConstructed(this.m_Tag)) {
            if (this.m_Children.size() != other.m_Children.size()) {
                return false;
            }
            int i = 0;
            while (i < this.m_Children.size()) {
                if (!this.m_Children.get(i).equals(other.m_Children.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (this.m_Value == null && other.m_Value == null) {
            return true;
        }
        return MBTools.IsEqual(this.m_Value, other.m_Value);
    }
}

