/*
 * Decompiled with CFR 0.152.
 */
package de.muehlbauer.mw.util.tlv;

import de.muehlbauer.mw.egov.ifc.EgovException;
import de.muehlbauer.mw.util.tlv.MBTools;
import de.muehlbauer.mw.util.tlv.TLVTree;
import de.muehlbauer.mw.util.tlv.ToolsException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public class TLVUtil {
    private static final int TAG_BOOLEAN = 1;
    private static final int TAG_INTEGER = 2;
    private static final int TAG_BITSTRING = 3;
    private static final int TAG_OCTETSTRING = 4;
    private static final int TAG_NULL = 5;
    private static final int TAG_OID = 6;
    private static final int TAG_UTF8STRING = 12;
    private static final int TAG_PRINTABLESTRING = 19;
    private static final int TAG_UTCTIME = 23;
    private static final int TAG_SEQUENCE = 48;
    private static final int TAG_SET = 49;
    private static HashMap<Integer, String> TagNames = new HashMap();

    static {
        TagNames.put(1, "BOOLEAN");
        TagNames.put(2, "INTEGER");
        TagNames.put(3, "BIT STRING");
        TagNames.put(4, "OCTET STRING");
        TagNames.put(5, "NULL");
        TagNames.put(6, "OID");
        TagNames.put(12, "UTF8String");
        TagNames.put(19, "PRINTABLE STRING");
        TagNames.put(23, "UTC TIME");
        TagNames.put(48, "SEQUENCE");
        TagNames.put(49, "SET");
    }

    public static String getTLV(byte[] tlvByte) throws IOException {
        try {
            TLVTree t = new TLVTree(tlvByte);
            StringBuffer b = new StringBuffer();
            TLVUtil.printTLV(t, 0, b);
            return b.toString();
        }
        catch (ToolsException e) {
            throw new IOException("incorrect TLV Structure");
        }
    }

    static void printTLV(TLVTree t, int indent, StringBuffer b) {
        if (indent != 0) {
            b.append('\n');
        }
        int i = 0;
        while (i < indent) {
            b.append("  ");
            ++i;
        }
        b.append(Integer.toString(t.getTag(), 16).toUpperCase());
        String tagName = TagNames.get(t.getTag());
        if (TLVTree.isConstructed(t.getTag()) && t.getChildren() != null) {
            if (tagName != null) {
                b.append(' ');
                b.append(tagName);
            }
            for (TLVTree c : t.getChildren()) {
                TLVUtil.printTLV(c, indent + 1, b);
            }
        } else {
            b.append(" (" + t.getValue().length + "): ");
            if (tagName != null) {
                b.append(' ');
                b.append(tagName);
                b.append(" : ");
            }
            switch (t.getTag()) {
                case 1: {
                    b.append(MBTools.IsEqual(t.getValue(), new byte[]{-1}));
                    break;
                }
                case 6: {
                    TLVUtil.printOID(t.getValue(), b);
                    break;
                }
                case 12: {
                    b.append('\"');
                    try {
                        b.append(new String(t.getValue(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    b.append('\"');
                }
                case 19: 
                case 23: {
                    b.append('\"');
                    b.append(new String(t.getValue()));
                    b.append('\"');
                    break;
                }
                default: {
                    b.append('\'');
                    b.append(MBTools.BytesToHex(t.getValue()));
                    b.append('\'');
                }
            }
        }
    }

    static String printOID(byte[] enc, StringBuffer b) {
        b.append(enc[0] / 40);
        b.append('.');
        b.append(enc[0] % 40);
        int i = 1;
        while (i < enc.length) {
            b.append('.');
            if ((enc[i] & 0xFFFFFF80) == 0) {
                b.append(enc[i++]);
                continue;
            }
            int val = 0;
            do {
                val = val << 7 | enc[i++] & 0x7F;
            } while (i < enc.length && (enc[i - 1] & 0xFFFFFF80) == -128);
            b.append(val);
        }
        return b.toString();
    }

    public static byte findCurveIdAfterPaceOID(String tlv, String oid) throws EgovException {
        String tlvAfterOid = tlv.substring(tlv.indexOf(oid) + oid.length());
        int i = 0;
        while (i < tlvAfterOid.length() - 3) {
            if (tlvAfterOid.charAt(i) == '\'') {
                String idString = tlvAfterOid.substring(i + 1, i + 3);
                try {
                    int idInt = Integer.parseInt(idString, 16);
                    if (idInt >= 8 && idInt <= 18) {
                        return (byte)idInt;
                    }
                    i += 3;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++i;
        }
        throw new EgovException("No Curve ID after OID");
    }
}

