/*
 * Decompiled with CFR 0.152.
 */
package de.muehlbauer.sscd;

import de.muehlbauer.mw.sscd.ifc.SscdCardServiceFactory;
import de.muehlbauer.mw.sscd.ifc.SscdCardServiceInterface;
import de.muehlbauer.mw.sscd.ifc.SscdException;
import de.muehlbauer.mw.util.MWUtil;
import de.muehlbauer.sscd.MBSystemAccess;
import de.muehlbauer.sscd.ToolEventListener;
import java.util.Enumeration;
import java.util.Observable;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.event.EventGenerator;
import opencard.core.service.CardRequest;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceRegistry;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.APDUTracer;
import opencard.core.util.OpenCardPropertyLoadingException;
import opencard.core.util.SystemAccess;

public class Tool {
    CardListener mbCardListener;
    private CardTerminal egovTerminal;
    private CardTerminalEvent lastTerminalEvent;
    private boolean hasEgov;
    private SscdCardServiceInterface sscdIfc;
    private ToolEventListener toolEventListener;
    private byte[] adminPinValue = new byte[]{57, 57, 57, 57, 57, 57};
    private byte[] adminPinValueDefault = new byte[]{57, 57, 57, 57, 57, 57};
    private byte[] userPinValue = new byte[]{48, 48, 48, 48, 48, 48};
    public static final byte ADMIN_PIN_ID = -111;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Use this tool the following way: java -jar tool.jar ActivationPin UserPin");
        } else {
            String userPinString;
            boolean pinsOk = true;
            String adminPinString = args[0];
            if (adminPinString.length() < 6 || adminPinString.length() > 20) {
                System.out.println("ActivationPin too short/long.");
                pinsOk = false;
            }
            if ((userPinString = args[1]).length() < 6 || userPinString.length() > 20) {
                System.out.println("UserPin too short/long.");
                pinsOk = false;
            }
            if (pinsOk) {
                Tool tool = new Tool(adminPinString, userPinString);
            }
        }
    }

    public Tool(String activationPin, String userPin) {
        System.out.println("Running the following OS:" + this.getOperatingSystem());
        if (this.getOperatingSystem().contains("Mac OS X")) {
            System.out.println("Setting PCSC framework for macOS");
            System.setProperty("sun.security.smartcardio.library", "/System/Library/Frameworks/PCSC.framework/Versions/Current/PCSC");
        }
        this.adminPinValue = activationPin.getBytes();
        this.userPinValue = userPin.getBytes();
        Tool t = new Tool(null, true);
        try {
            t.activate(activationPin, userPin);
        }
        catch (SscdException | CardTerminalException e) {
            e.printStackTrace();
        }
    }

    public Tool(ToolEventListener listener, boolean activate) {
        System.out.println("Running the following OS:" + this.getOperatingSystem());
        if (this.getOperatingSystem().contains("Mac OS X")) {
            System.out.println("Setting PCSC framework for macOS");
            System.setProperty("sun.security.smartcardio.library", "/System/Library/Frameworks/PCSC.framework/Versions/Current/PCSC");
        }
        ClassLoader loader = Tool.class.getClassLoader();
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        if (listener != null) {
            this.toolEventListener = listener;
        }
        this.initializeOCF(activate);
    }

    public void activate(String puk, String pin) throws CardTerminalException, SscdException {
        this.mbCardListener.startActivation(puk, pin);
    }

    private void initializeOCF(boolean activate) {
        SystemAccess.setSystemAccess((SystemAccess)new MBSystemAccess());
        Enumeration csf = CardServiceRegistry.getRegistry().getCardServiceFactories();
        boolean foundEgov = false;
        while (csf.hasMoreElements()) {
            if (csf.nextElement().getClass() != SscdCardServiceFactory.class) continue;
            foundEgov = true;
            System.out.println("Found SSCD middelware!");
            if (this.toolEventListener != null) {
                this.toolEventListener.eventOccured(1000700, "SSCD available", null);
            }
            this.hasEgov = true;
        }
        if (!foundEgov) {
            CardServiceRegistry.getRegistry().add((CardServiceFactory)new SscdCardServiceFactory());
        }
        Enumeration csf2 = CardServiceRegistry.getRegistry().getCardServiceFactories();
        while (csf2.hasMoreElements()) {
            if (csf2.nextElement().getClass() != SscdCardServiceFactory.class) continue;
            foundEgov = true;
            System.out.println("Finally found SSCD middleware!");
            this.hasEgov = true;
        }
        try {
            if (!SmartCard.isStarted()) {
                SmartCard.start();
            }
            this.mbCardListener = new CardListener(activate);
        }
        catch (ClassNotFoundException | CardServiceException | CardTerminalException | OpenCardPropertyLoadingException e) {
            e.printStackTrace();
        }
    }

    public void release() throws SscdException {
        this.mbCardListener.releaseChannel();
    }

    public String getOperatingSystem() {
        String os = System.getProperty("os.name");
        return os;
    }

    private class CardListener
    extends Observable
    implements CTListener {
        Boolean appletSelected = false;

        protected CardListener() throws CardTerminalException {
            EventGenerator.getGenerator().addCTListener((CTListener)this);
            EventGenerator.getGenerator().createEventsForPresentCards((CTListener)this);
        }

        private void release() {
            EventGenerator.getGenerator().removeCTListener((CTListener)this);
        }

        private void releaseChannel() throws SscdException {
            Tool.this.sscdIfc.release();
        }

        public CardListener(boolean startActivation) throws CardTerminalException {
            EventGenerator.getGenerator().addCTListener((CTListener)this);
            EventGenerator.getGenerator().createEventsForPresentCards((CTListener)this);
        }

        public void startActivation(String puk, String pin) throws CardTerminalException, SscdException {
            if (Tool.this.sscdIfc == null) {
                throw new SscdException("No card connection found");
            }
            byte[] pukValue = puk.getBytes();
            byte[] pinValue = pin.getBytes();
            String cardSn = MWUtil.byteToHex(Tool.this.sscdIfc.readSerialNumber());
            System.out.println("SerialNumber: " + cardSn);
            SmartCard sc = SmartCard.getSmartCard((CardTerminalEvent)Tool.this.lastTerminalEvent, (CardRequest)new CardRequest(1, null, null));
            sc.reset(false);
            boolean pinOk = false;
            boolean pukOk = false;
            try {
                pinOk = Tool.this.sscdIfc.verifyUserPin(pin.getBytes());
            }
            catch (SscdException e) {
                System.out.println("PIN could not be verified!");
                this.publishEvent(1000006, "PIN verification failed!.", e.getSwHex(), Tool.this.toolEventListener);
            }
            if (pinOk) {
                boolean tokenInfoActivated = false;
                boolean pukVerified = false;
                try {
                    pukVerified = Tool.this.sscdIfc.verifyUserPuk(pukValue);
                }
                catch (SscdException e) {
                    this.publishEvent(1000005, "PUK verification failed!.", e.getSwHex(), Tool.this.toolEventListener);
                }
                if (pukVerified) {
                    if (Tool.this.sscdIfc.selectADF()[0] == -112) {
                        if (Tool.this.sscdIfc.selectEfTokenInfo()[0] == 98) {
                            if (!Tool.this.sscdIfc.activateFile()) {
                                System.out.println("Ef.Token Info activation failed.");
                                this.publishEvent(1000015, "Activation failed.", null, Tool.this.toolEventListener);
                            } else {
                                tokenInfoActivated = true;
                                Tool.this.sscdIfc.selectApplet();
                            }
                        } else {
                            System.out.println("Ef.Token Info selection failed.");
                            this.publishEvent(1000015, "Activation failed.", null, Tool.this.toolEventListener);
                        }
                    } else {
                        System.out.println("ADF selection failed.");
                        this.publishEvent(1000015, "Activation failed.", null, Tool.this.toolEventListener);
                    }
                } else {
                    throw new SscdException("PUK verification failed!");
                }
                sc.reset(false);
                if (this.appletSelected.booleanValue()) {
                    Tool.this.sscdIfc.selectApplet();
                    if (Tool.this.sscdIfc.isSscdActivated()) {
                        System.out.println("Already activated!");
                        this.publishEvent(1000010, "SSCD already activated.", null, Tool.this.toolEventListener);
                    } else {
                        System.out.println("Not yet activated! Starting process ...");
                        this.publishEvent(1000003, "Activation initiated.", null, Tool.this.toolEventListener);
                        if (Tool.this.sscdIfc.authIasEcc()) {
                            System.out.println("Authenticated against SSCD with IAS-ECC.");
                            try {
                                pukOk = Tool.this.sscdIfc.verifyAdminPin(pukValue);
                            }
                            catch (SscdException e) {
                                System.out.println("PUK could not be verified!");
                                this.publishEvent(1000005, "PUK verification failed!.", e.getSwHex(), Tool.this.toolEventListener);
                            }
                            if (pukOk) {
                                System.out.println("Verified for activation");
                                if (Tool.this.sscdIfc.activateFile()) {
                                    System.out.println("DS_DF activated");
                                    if (Tool.this.sscdIfc.unblockRadPin(pinValue)) {
                                        System.out.println("RAD PIN unblocked");
                                        if (Tool.this.sscdIfc.verifyRadPin(pinValue)) {
                                            System.out.println("RAD PIN verified");
                                            System.out.println("SSCD activated. Now fully operational.");
                                            this.publishEvent(1000004, "Activation finished.", null, Tool.this.toolEventListener);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                throw new SscdException("PIN verification failed!");
            }
        }

        private void publishEvent(int eventCode, String message, String message2, ToolEventListener listener) {
            if (listener != null) {
                listener.eventOccured(eventCode, message, message2);
            } else {
                System.out.println("No listener registered! (" + eventCode + "/" + message + ")");
            }
        }

        private void initializeSscdCard() throws CardTerminalException {
            try {
                SmartCard sc = SmartCard.getSmartCard((CardTerminalEvent)Tool.this.lastTerminalEvent, (CardRequest)new CardRequest(1, null, null));
                System.out.println("Initializing MBMiddleWare ...");
                MbTracer mbTracer = new MbTracer();
                sc.setAPDUTracer((APDUTracer)mbTracer);
                sc.reset(true);
                Tool.this.sscdIfc = (SscdCardServiceInterface)sc.getCardService(SscdCardServiceInterface.class, true);
                this.appletSelected = Tool.this.sscdIfc.selectApplet();
                if (this.appletSelected.booleanValue()) {
                    if (Tool.this.sscdIfc.isSscdActivated()) {
                        System.out.println("Already activated!");
                        this.publishEvent(1000010, "SSCD already activated.", null, Tool.this.toolEventListener);
                    } else {
                        System.out.println("Card not activated!");
                        this.publishEvent(1000013, "SSCD not yet activated.", null, Tool.this.toolEventListener);
                    }
                }
                Tool.this.hasEgov = true;
            }
            catch (NullPointerException e) {
                System.out.println(e.getMessage());
            }
            catch (CardTerminalException e) {
                System.out.println(e.getMessage());
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }

        public void cardInserted(CardTerminalEvent ev) throws CardTerminalException {
            String tn = ev.getCardTerminal().getName();
            boolean isEgov = false;
            System.out.println("Card inserted! " + tn + "  " + System.currentTimeMillis() + " ev: " + ev.toString());
            Tool.this.egovTerminal = ev.getCardTerminal();
            Tool.this.lastTerminalEvent = ev;
            if (Tool.this.toolEventListener != null) {
                Tool.this.toolEventListener.eventOccured(1000700, "Selected", null);
            }
            this.initializeSscdCard();
        }

        public void cardRemoved(CardTerminalEvent ev) throws CardTerminalException {
            String tn = ev.getCardTerminal().getName();
            System.out.println("Card removed!");
            Tool.this.lastTerminalEvent = ev;
            try {
                Tool.this.sscdIfc.release();
            }
            catch (SscdException e) {
                e.printStackTrace();
            }
            if (Tool.this.egovTerminal == ev.getCardTerminal()) {
                Tool.this.egovTerminal = null;
                Tool.this.hasEgov = false;
                if (Tool.this.toolEventListener != null) {
                    Tool.this.toolEventListener.eventOccured(1000002, "Removed", null);
                }
            }
        }

        private class MbTracer
        implements APDUTracer {
            private MbTracer() {
            }

            public void traceAnswerToReset(SlotChannel arg0, CardID arg1) {
            }

            public void traceCommandAPDU(SlotChannel arg0, CommandAPDU arg1) {
            }

            public void traceResponseAPDU(SlotChannel arg0, ResponseAPDU arg1) {
            }
        }
    }
}

