/*
 * Decompiled with CFR 0.152.
 */
package de.muehlbauer.sscd.activation.gui;

import de.muehlbauer.mw.sscd.ifc.SscdException;
import de.muehlbauer.sscd.Tool;
import de.muehlbauer.sscd.ToolEventListener;
import de.muehlbauer.sscd.activation.gui.AboutController;
import de.muehlbauer.sscd.activation.gui.AbstractController;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import opencard.core.terminal.CardTerminalException;

public class Controller
extends AbstractController
implements Initializable,
ToolEventListener {
    Tool activationTool = null;
    private boolean hasSSCD;
    private Tooltip pinTooltip;
    private Tooltip pukTooltip;
    @FXML
    private MenuItem closeButton;
    @FXML
    private Label GIDScardStatusLabel;
    @FXML
    private Button activationButton;
    @FXML
    private PasswordField pinPwField;
    @FXML
    private PasswordField pukPwField;
    @FXML
    private TextArea logarea;
    @FXML
    private Label pinLabel;
    @FXML
    private Label pukLabel;
    @FXML
    private AnchorPane anchorPane;
    ResourceBundle bundle;
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private boolean clearOnNext = false;

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
            ++j;
        }
        return new String(hexChars);
    }

    @FXML
    private void closeButtonAction() {
        Platform.exit();
    }

    @FXML
    private void aboutButtonAction() {
        Locale locale = Locale.getDefault();
        ResourceBundle bundle = ResourceBundle.getBundle("bundles/SSCD", locale);
        URL fxmlURL = this.getClass().getResource("/de/muehlbauer/sscd/activation/gui/about.fxml");
        FXMLLoader loader = new FXMLLoader(fxmlURL, bundle);
        AboutController aboutController = new AboutController();
        loader.setController((Object)aboutController);
        try {
            Parent layout = (Parent)loader.load();
            Scene scene = new Scene(layout);
            Stage popupStage = new Stage();
            aboutController.setStage(popupStage);
            if (this.main != null) {
                popupStage.initOwner((Window)this.main.getPrimaryStage());
            }
            popupStage.setResizable(false);
            popupStage.initModality(Modality.WINDOW_MODAL);
            popupStage.setScene(scene);
            popupStage.showAndWait();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void initialize(URL arg0, ResourceBundle arg1) {
        this.bundle = arg1;
        this.disableUI(true);
        this.activationTool = new Tool(this, false);
    }

    private void showCardStatus(final boolean cardAvailable) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (cardAvailable) {
                    Controller.this.appendToLogView(Controller.this.bundle.getString("sscd.gui.card.found"));
                } else {
                    Controller.this.appendToLogView(Controller.this.bundle.getString("sscd.gui.card.notfound"), true);
                }
            }
        });
    }

    @FXML
    private void showPin() {
        this.pinTooltip = new Tooltip();
        this.pinTooltip.setAutoHide(true);
        this.pinTooltip.setMinWidth(50.0);
        Stage stage = (Stage)this.anchorPane.getScene().getWindow();
        Point2D p = this.pinPwField.localToScene(this.pinPwField.getBoundsInLocal().getMaxX(), this.pinPwField.getBoundsInLocal().getMaxY());
        this.pinTooltip.setText(this.pinPwField.getText());
        this.pinTooltip.show((Node)this.pinPwField, p.getX() + stage.getScene().getX() + stage.getX(), p.getY() + stage.getScene().getY() + stage.getY());
    }

    @FXML
    private void showPuk() {
        this.pukTooltip = new Tooltip();
        this.pukTooltip.setAutoHide(true);
        this.pukTooltip.setMinWidth(50.0);
        Stage stage = (Stage)this.anchorPane.getScene().getWindow();
        Point2D p = this.pukPwField.localToScene(this.pukPwField.getBoundsInLocal().getMaxX(), this.pukPwField.getBoundsInLocal().getMaxY());
        this.pukTooltip.setText(this.pukPwField.getText());
        this.pukTooltip.show((Node)this.pukPwField, p.getX() + stage.getScene().getX() + stage.getX(), p.getY() + stage.getScene().getY() + stage.getY());
    }

    @FXML
    private void activateSscd() {
        try {
            String puk = this.pukPwField.getText();
            String pin = this.pinPwField.getText();
            boolean checksOk = true;
            if (puk.length() != 6) {
                checksOk = false;
                this.appendToLogView(this.bundle.getString("sscd.gui.verification.puk.wronglength"));
            }
            if (pin.length() != 6) {
                checksOk = false;
                this.appendToLogView(this.bundle.getString("sscd.gui.verification.pin.wronglength"));
            }
            if (checksOk) {
                this.activationTool.activate(puk, pin);
            }
        }
        catch (CardTerminalException e) {
            this.appendToLogView(String.valueOf(this.bundle.getString("sscd.gui.activationfailed")) + e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (SscdException ex) {
            this.appendToLogView(this.bundle.getString("sscd.gui.activationfailed"));
            ex.printStackTrace();
        }
    }

    private void clearFields() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Controller.this.logarea.setText("");
            }
        });
    }

    private void appendToLogView(String input) {
        this.appendToLogView(input, false);
    }

    private void appendToLogView(String input, boolean clearOnNext) {
        if (this.clearOnNext) {
            this.logarea.setText("");
        }
        this.clearOnNext = clearOnNext;
        this.logarea.appendText(String.valueOf(System.lineSeparator()) + input);
    }

    private void disableUI(boolean status) {
        this.activationButton.setDisable(status);
        this.pinPwField.setDisable(status);
        this.pinPwField.setText("");
        this.pukPwField.setDisable(status);
        this.pukPwField.setText("");
    }

    @Override
    public void eventOccured(int eventCode, String message, String message2) {
        System.out.println(String.valueOf(message) + ":  " + eventCode);
        switch (eventCode) {
            case 1000700: {
                this.hasSSCD = true;
                this.disableUI(true);
                this.appendToLogView(this.bundle.getString("sscd.gui.card.found"));
                break;
            }
            case 1000000: {
                this.hasSSCD = true;
                this.disableUI(false);
                this.showCardStatus(this.hasSSCD);
                break;
            }
            case 1000002: {
                this.hasSSCD = false;
                this.disableUI(true);
                this.showCardStatus(false);
                break;
            }
            case 1000010: {
                this.hasSSCD = true;
                this.disableUI(true);
                this.appendToLogView(this.bundle.getString("sscd.gui.card.alreadyactive"));
                break;
            }
            case 1000013: {
                this.hasSSCD = true;
                this.disableUI(false);
                this.appendToLogView(this.bundle.getString("sscd.gui.card.deactivated"));
                break;
            }
            case 1000003: {
                this.hasSSCD = true;
                this.disableUI(true);
                this.appendToLogView(this.bundle.getString("sscd.gui.status.activationstarted"));
                break;
            }
            case 1000004: {
                this.hasSSCD = true;
                this.disableUI(true);
                this.appendToLogView(this.bundle.getString("sscd.gui.activationfinished"));
                break;
            }
            case 1000006: {
                this.hasSSCD = true;
                this.disableUI(true);
                this.appendToLogView(String.valueOf(this.bundle.getString("sscd.gui.verification.pin.failed")) + " " + this.swToPinPukState(message2));
                break;
            }
            case 1000005: {
                this.hasSSCD = true;
                this.disableUI(true);
                this.appendToLogView(String.valueOf(this.bundle.getString("sscd.gui.verification.puk.failed")) + " " + this.swToPinPukState(message2));
            }
        }
    }

    private String swToPinPukState(String sw) {
        String state = "";
        if (sw.length() != 4) {
            return state;
        }
        if (sw.startsWith("63")) {
            state = String.valueOf(this.bundle.getString("sscd.gui.pinpuk.retriesleft")) + " " + sw.charAt(3);
        }
        if (sw.startsWith("6983")) {
            state = this.bundle.getString("sscd.gui.pinpuk.blocked");
        }
        return state;
    }
}

