/*
 * Decompiled with CFR 0.152.
 */
package de.muehlbauer.sscd.activation.gui;

import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Stage;

public class Main
extends Application {
    private static String localeOverride = "en_US";
    private Stage primaryStage;

    public void start(Stage primaryStage) {
        try {
            URL fxmlURL = ((Object)((Object)this)).getClass().getResource("/de/muehlbauer/sscd/activation/gui/eGovToolGUIScene.fxml");
            System.out.println("loading " + localeOverride + " locale bundle");
            Locale overridden = new Locale(localeOverride);
            ResourceBundle bundle = ResourceBundle.getBundle("bundles/SSCD", overridden);
            System.out.println(Locale.getDefault().toString());
            Locale.setDefault(overridden);
            System.out.println(Locale.getDefault().toString());
            System.out.println(bundle.getLocale().toString());
            System.out.println(overridden.toString());
            System.out.println("Starting " + bundle.getString("gidsadmin.gui.title"));
            System.out.println(bundle.toString());
            FXMLLoader loader = new FXMLLoader(fxmlURL, bundle);
            Parent root = (Parent)loader.load();
            String css = ((Object)((Object)this)).getClass().getResource("/de/muehlbauer/sscd/activation/gui/application.css").toExternalForm();
            root.getStylesheets().add((Object)css);
            primaryStage.setTitle(bundle.getString("gidsadmin.gui.title"));
            primaryStage.setResizable(false);
            primaryStage.setScene(new Scene(root));
            Image icon = new Image("/de/muehlbauer/sscd/activation/gui/chip.png");
            primaryStage.getIcons().add((Object)icon);
            primaryStage.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        block13: {
            String locale;
            System.out.println("v1.0.5");
            if (args.length <= 0) break block13;
            switch (locale = args[0]) {
                case "en": {
                    localeOverride = "en_US";
                    break;
                }
                case "de": {
                    localeOverride = "de_DE";
                    break;
                }
                case "mne": {
                    localeOverride = "sr_Latn_ME";
                    break;
                }
                default: {
                    System.out.println("Unkonwn language parameter. Falling back to en_US");
                    localeOverride = "en_US";
                }
            }
        }
        Main.launch((String[])args);
    }

    public Stage getPrimaryStage() {
        return this.primaryStage;
    }
}

